/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwapIfStatementsIntentionAction
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
        PsiIfStatement nestedIfStatement = (PsiIfStatement)ifStatement.getElseBranch();
        assert (nestedIfStatement != null);
        PsiExpression condition2 = ifStatement.getCondition();
        PsiExpression nestedCondition = nestedIfStatement.getCondition();
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement nestedThenBranch = nestedIfStatement.getThenBranch();
        assert (condition2 != null);
        assert (nestedCondition != null);
        assert (thenBranch != null);
        assert (nestedThenBranch != null);
        PsiElement conditionCopy = condition2.copy();
        condition2.replace((PsiElement)nestedCondition);
        nestedCondition.replace(conditionCopy);
        PsiElement thenBranchCopy = thenBranch.copy();
        thenBranch.replace((PsiElement)nestedThenBranch);
        nestedThenBranch.replace(thenBranchCopy);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!(element instanceof PsiKeyword) || !"else".equals(element.getText())) {
            return false;
        }
        PsiElement parent = element.getParent();
        return SwapIfStatementsIntentionAction.isWellFormedIf(parent) && SwapIfStatementsIntentionAction.isWellFormedIf((PsiElement)((PsiIfStatement)parent).getElseBranch());
    }

    private static boolean isWellFormedIf(@Nullable PsiElement e) {
        return e instanceof PsiIfStatement && ((PsiIfStatement)e).getCondition() != null && ((PsiIfStatement)e).getThenBranch() != null;
    }

    @NotNull
    public String getFamilyName() {
        return "Swap 'if' statements";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }
}

