/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class TypeExpression
extends Expression {
    private final LinkedHashSet<SmartTypePointer> myItems = new LinkedHashSet();

    public TypeExpression(@NotNull Project project, @NotNull PsiType[] types) {
        SmartTypePointerManager manager = SmartTypePointerManager.getInstance((Project)project);
        for (PsiType type2 : types) {
            this.myItems.add(manager.createSmartTypePointer(type2));
        }
    }

    public TypeExpression(@NotNull Project project, @NotNull Iterable<? extends PsiType> types) {
        SmartTypePointerManager manager = SmartTypePointerManager.getInstance((Project)project);
        for (PsiType psiType : types) {
            this.myItems.add(manager.createSmartTypePointer(psiType));
        }
    }

    public Result calculateResult(ExpressionContext context) {
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (this.myItems.isEmpty()) {
            return null;
        }
        PsiType type2 = ((SmartTypePointer)this.myItems.iterator().next()).getType();
        return type2 == null ? null : new PsiTypeResult(type2, project){

            @Override
            public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
                if (TypeExpression.this.myItems.size() <= 1) {
                    super.handleRecalc(psiFile, document, segmentStart, segmentEnd);
                } else {
                    JavaTemplateUtil.updateTypeBindings(this.getType(), psiFile, document, segmentStart, segmentEnd, true);
                }
            }
        };
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        if (this.myItems.size() <= 1) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        ArrayList<PsiTypeLookupItem> result = new ArrayList<PsiTypeLookupItem>(this.myItems.size());
        for (SmartTypePointer item : this.myItems) {
            PsiType type2 = item.getType();
            if (type2 == null) continue;
            result.add(PsiTypeLookupItem.createLookupItem(type2, null));
        }
        return result.toArray(LookupElement.EMPTY_ARRAY);
    }
}

