/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageLookupItem
extends LookupElement {
    private final PsiPackage myPackage;
    private final String myString;
    private final boolean myAddDot;

    public PackageLookupItem(@NotNull PsiPackage aPackage) {
        this(aPackage, null);
    }

    public PackageLookupItem(@NotNull PsiPackage pkg, @Nullable PsiElement context) {
        this.myPackage = pkg;
        this.myString = StringUtil.notNullize((String)this.myPackage.getName());
        PsiFile file = context == null ? null : context.getContainingFile();
        this.myAddDot = !(file instanceof PsiJavaCodeReferenceCodeFragment) || ((PsiJavaCodeReferenceCodeFragment)file).isClassesAccepted();
    }

    @NotNull
    public Object getObject() {
        return this.myPackage;
    }

    @NotNull
    public String getLookupString() {
        return this.myString;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        if (this.myAddDot) {
            presentation.setItemText(this.myString + ".");
        }
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (this.myAddDot) {
            context.setAddCompletionChar(false);
            TailType.DOT.processTail(context.getEditor(), context.getTailOffset());
        }
        if (this.myAddDot || context.getCompletionChar() == '.') {
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        }
    }
}

