/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class JavaGotoSuperHandler
implements PresentableCodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        int offset = editor.getCaretModel().getOffset();
        PsiElement[] superElements = this.findSuperElements(file, offset);
        if (superElements.length == 0) {
            return;
        }
        if (superElements.length == 1) {
            PsiElement superElement = superElements[0].getNavigationElement();
            PsiFile containingFile = superElement.getContainingFile();
            if (containingFile == null) {
                return;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, superElement.getTextOffset());
            descriptor.navigate(true);
        } else if (superElements[0] instanceof PsiMethod) {
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])((PsiMethod[])superElements));
            PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])((PsiMethod[])superElements), (String)CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{((PsiMethod)superElements[0]).getName()}), (ListCellRenderer)((Object)new MethodCellRenderer(showMethodNames)));
        } else {
            NavigationUtil.getPsiElementPopup((PsiElement[])superElements, (String)CodeInsightBundle.message((String)"goto.super.class.chooser.title", (Object[])new Object[0])).showInBestPositionFor(editor);
        }
    }

    @NotNull
    private PsiElement[] findSuperElements(@NotNull PsiFile file, int offset) {
        PsiMethod interfaceMethod;
        PsiElement element = this.getElement(file, offset);
        if (element == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMember.class});
        if (psiElement instanceof PsiFunctionalExpression && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)psiElement)) != null) {
            return (PsiElement[])ArrayUtil.prepend((Object)interfaceMethod, (Object[])interfaceMethod.findSuperMethods(false));
        }
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        return FindSuperElementsHelper.findSuperElements((PsiElement)parent);
    }

    protected PsiElement getElement(@NotNull PsiFile file, int offset) {
        return file.findElementAt(offset);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void update(@NotNull Editor editor, @NotNull PsiFile file, Presentation presentation) {
        PsiElement element = this.getElement(file, editor.getCaretModel().getOffset());
        PsiElement containingElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiFunctionalExpression.class, PsiMember.class});
        if (containingElement instanceof PsiClass) {
            presentation.setText(ActionsBundle.actionText((String)"GotoSuperClass"));
            presentation.setDescription(ActionsBundle.actionDescription((String)"GotoSuperClass"));
        } else {
            presentation.setText(ActionsBundle.actionText((String)"GotoSuperMethod"));
            presentation.setDescription(ActionsBundle.actionDescription((String)"GotoSuperMethod"));
        }
    }
}

