/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.StdLanguages;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class JavaCommentContextType
extends TemplateContextType {
    public JavaCommentContextType() {
        super("JAVA_COMMENT", "Comment", JavaCodeContextType.Generic.class);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset).isKindOf(StdLanguages.JAVA)) {
            PsiElement element = file.findElementAt(offset);
            if (element instanceof PsiWhiteSpace && offset > 0) {
                element = file.findElementAt(offset - 1);
            }
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null;
        }
        return false;
    }
}

