/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.postfix.templates.JavaPostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaEditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaPostfixTemplateExpressionCondition;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class OptionalPostfixTemplate
extends JavaEditablePostfixTemplate {
    public OptionalPostfixTemplate(@NotNull JavaPostfixTemplateProvider provider) {
        super("opt", "java.util.$OPTIONAL_CLASS$.$OPTIONAL_METHOD$($EXPR$)", "Optional.ofNullable(expr)", Collections.singleton(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNonVoidExpressionCondition()), LanguageLevel.JDK_1_8, true, provider);
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    protected void addTemplateVariables(@NotNull PsiElement element, @NotNull Template template) {
        super.addTemplateVariables(element, template);
        template.addVariable("OPTIONAL_CLASS", (Expression)new TextExpression(OptionalPostfixTemplate.getClassName(element)), false);
        template.addVariable("OPTIONAL_METHOD", (Expression)new TextExpression(OptionalPostfixTemplate.getMethodName(element)), false);
    }

    private static String getMethodName(@NotNull PsiElement element) {
        if (element instanceof PsiExpression && Nullability.NOT_NULL == NullabilityUtil.getExpressionNullability((PsiExpression)element, true)) {
            return "of";
        }
        return "ofNullable";
    }

    @NotNull
    private static String getClassName(@NotNull PsiElement element) {
        PsiType type2;
        String className = "Optional";
        PsiType psiType = type2 = element instanceof PsiExpression ? ((PsiExpression)element).getType() : null;
        if (type2 instanceof PsiPrimitiveType) {
            if (PsiType.INT.equals((Object)type2)) {
                className = "OptionalInt";
            } else if (PsiType.DOUBLE.equals((Object)type2)) {
                className = "OptionalDouble";
            } else if (PsiType.LONG.equals((Object)type2)) {
                className = "OptionalLong";
            }
        }
        return className;
    }
}

