/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates.editable;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateEditorBase;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaEditablePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.JavaPostfixTemplateExpressionCondition;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPostfixTemplateEditor
extends PostfixTemplateEditorBase<JavaPostfixTemplateExpressionCondition> {
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final ComboBox<LanguageLevel> myLanguageLevelCombo = new ComboBox((Object[])LanguageLevel.values());

    public JavaPostfixTemplateEditor(@NotNull PostfixTemplateProvider provider) {
        super(provider, JavaPostfixTemplateEditor.createEditor(), true);
        this.myLanguageLevelCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<LanguageLevel>(){

            protected void customizeCellRenderer(@NotNull JList list, LanguageLevel value2, int index, boolean selected, boolean hasFocus) {
                this.append(value2.getPresentableText());
            }
        });
        this.myPanel = FormBuilder.createFormBuilder().addLabeledComponent("Minimum language level:", this.myLanguageLevelCombo).addComponent((JComponent)this.myEditTemplateAndConditionsPanel).getPanel();
    }

    @NotNull
    private static Editor createEditor() {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        return JavaPostfixTemplateEditor.createEditor((Project)defaultProject, (Document)JavaPostfixTemplateEditor.createDocument(defaultProject));
    }

    @NotNull
    public JavaEditablePostfixTemplate createTemplate(@NotNull String templateId, @NotNull String templateName) {
        LanguageLevel selectedLanguageLevel = (LanguageLevel)ObjectUtils.tryCast((Object)this.myLanguageLevelCombo.getSelectedItem(), LanguageLevel.class);
        LanguageLevel languageLevel = (LanguageLevel)ObjectUtils.notNull((Object)selectedLanguageLevel, (Object)LanguageLevel.JDK_1_3);
        LinkedHashSet conditions = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addAll((Collection)conditions, this.myExpressionTypesListModel.elements());
        String templateText = this.myTemplateEditor.getDocument().getText();
        boolean useTopmostExpression = this.myApplyToTheTopmostJBCheckBox.isSelected();
        return new JavaEditablePostfixTemplate(templateId, templateName, templateText, "", (Set<JavaPostfixTemplateExpressionCondition>)conditions, languageLevel, useTopmostExpression, this.myProvider);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private static Document createDocument(@Nullable Project project) {
        if (project == null) {
            return EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        JavaCodeFragment fragment = factory.createCodeBlockCodeFragment("", (PsiElement)psiFacade.findPackage(""), true);
        DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)fragment, false);
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }

    protected void fillConditions(@NotNull DefaultActionGroup group) {
        Project[] projects;
        group.add((AnAction)new PostfixTemplateEditorBase.AddConditionAction((PostfixTemplateEditorBase)this, (PostfixTemplateExpressionCondition)new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateVoidExpressionCondition()));
        group.add((AnAction)new PostfixTemplateEditorBase.AddConditionAction((PostfixTemplateEditorBase)this, (PostfixTemplateExpressionCondition)new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNonVoidExpressionCondition()));
        group.add((AnAction)new PostfixTemplateEditorBase.AddConditionAction((PostfixTemplateEditorBase)this, (PostfixTemplateExpressionCondition)new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateBooleanExpressionCondition()));
        group.add((AnAction)new PostfixTemplateEditorBase.AddConditionAction((PostfixTemplateEditorBase)this, (PostfixTemplateExpressionCondition)new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNumberExpressionCondition()));
        group.add((AnAction)new PostfixTemplateEditorBase.AddConditionAction((PostfixTemplateEditorBase)this, (PostfixTemplateExpressionCondition)new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateNotPrimitiveTypeExpressionCondition()));
        group.add((AnAction)new PostfixTemplateEditorBase.AddConditionAction((PostfixTemplateEditorBase)this, (PostfixTemplateExpressionCondition)new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateArrayExpressionCondition()));
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            group.add((AnAction)new ChooseClassAction(project));
        }
        group.add((AnAction)new ChooseClassAction(null));
    }

    public void setTemplate(@Nullable PostfixTemplate template) {
        super.setTemplate(template);
        if (template instanceof JavaEditablePostfixTemplate) {
            this.myLanguageLevelCombo.setSelectedItem((Object)((JavaEditablePostfixTemplate)template).getMinimumLanguageLevel());
        }
    }

    private class ChooseClassAction
    extends DumbAwareAction {
        @Nullable
        private final Project myProject;

        protected ChooseClassAction(Project project) {
            super(project != null && !project.isDefault() ? "choose class in " + project.getName() + "..." : "enter class name...");
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String fqn = this.getFqn();
            if (fqn != null) {
                JavaPostfixTemplateEditor.this.myExpressionTypesListModel.addElement(new JavaPostfixTemplateExpressionCondition.JavaPostfixTemplateExpressionFqnCondition(fqn));
            }
        }

        private String getFqn() {
            String title = "Choose Class";
            if (this.myProject == null || this.myProject.isDefault()) {
                return Messages.showInputDialog((Component)JavaPostfixTemplateEditor.this.myPanel, (String)title, (String)title, null);
            }
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.myProject).createAllProjectScopeChooser(title);
            chooser.showDialog();
            PsiClass selectedClass = chooser.getSelected();
            return selectedClass != null ? selectedClass.getQualifiedName() : null;
        }
    }
}

