/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPolyadicExpressionUnwrapper
extends JavaUnwrapper {
    public JavaPolyadicExpressionUnwrapper() {
        super("");
    }

    @NotNull
    public String getDescription(@NotNull PsiElement e) {
        return CodeInsightBundle.message((String)"unwrap.with.placeholder", (Object[])new Object[]{e.getText()});
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (!(e.getParent() instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)e.getParent();
        PsiExpression operand2 = JavaPolyadicExpressionUnwrapper.findOperand(e, expression2);
        return operand2 != null;
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiPolyadicExpression parent = (PsiPolyadicExpression)element.getParent();
        PsiExpression operand2 = JavaPolyadicExpressionUnwrapper.findOperand(element, parent);
        if (operand2 == null) {
            return;
        }
        context.extractElement((PsiElement)operand2, (PsiElement)parent);
        if (parent.getParent() instanceof PsiVariable) {
            context.deleteExactly((PsiElement)parent);
        } else {
            context.delete((PsiElement)parent);
        }
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return e.getParent();
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression2) {
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand2 : expression2.getOperands()) {
            TextRange operandTextRange = operand2.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand2;
        }
        return null;
    }
}

