/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaSwitchExpressionUnwrapper
extends JavaUnwrapper {
    public JavaSwitchExpressionUnwrapper() {
        super("Unwrap 'switch' expression");
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)e).getBody() instanceof PsiExpressionStatement && ((PsiSwitchLabeledRuleStatement)e).getEnclosingSwitchBlock() instanceof PsiSwitchExpression;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)e;
        return rule.getEnclosingSwitchBlock();
    }

    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) {
        PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)element;
        PsiSwitchBlock block = rule.getEnclosingSwitchBlock();
        PsiStatement body2 = rule.getBody();
        assert (body2 instanceof PsiExpressionStatement);
        context.extractElement((PsiElement)((PsiExpressionStatement)body2).getExpression(), (PsiElement)block);
        context.deleteExactly((PsiElement)block);
    }
}

