/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;

public abstract class JavaUnwrapper
extends AbstractUnwrapper<Context> {
    public JavaUnwrapper(String description) {
        super(description);
    }

    protected Context createContext() {
        return new Context();
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        public void extractFromBlockOrSingleStatement(PsiStatement block, PsiElement from) throws IncorrectOperationException {
            if (block instanceof PsiBlockStatement) {
                this.extractFromCodeBlock(((PsiBlockStatement)block).getCodeBlock(), from);
            } else if (block != null && !(block instanceof PsiEmptyStatement)) {
                this.extract((PsiElement)block, (PsiElement)block, from);
            }
        }

        public void extractFromCodeBlock(PsiCodeBlock block, PsiElement from) throws IncorrectOperationException {
            if (block == null) {
                return;
            }
            this.extract(block.getFirstBodyElement(), block.getLastBodyElement(), from);
        }

        public void setElseBranch(PsiIfStatement ifStatement, PsiStatement elseBranch) throws IncorrectOperationException {
            PsiStatement toExtract = elseBranch;
            if (this.myIsEffective) {
                ifStatement.setElseBranch(Context.copyElement(elseBranch));
                toExtract = ifStatement.getElseBranch();
            }
            this.addElementToExtract((PsiElement)toExtract);
        }

        protected boolean isWhiteSpace(PsiElement element) {
            return element instanceof PsiWhiteSpace;
        }

        private static PsiStatement copyElement(PsiStatement e) throws IncorrectOperationException {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)e.getProject());
            return factory.createStatementFromText(e.getText(), null);
        }

        public void setInitializer(PsiVariable variable, PsiExpression returnValue) {
            PsiExpression toExtract = returnValue;
            if (this.myIsEffective) {
                PsiExpression initializer = Context.copyExpression(returnValue);
                variable.setInitializer(initializer);
                toExtract = variable.getInitializer();
            }
            this.addElementToExtract((PsiElement)toExtract);
        }

        private static PsiExpression copyExpression(PsiExpression returnValue) {
            return JavaPsiFacade.getElementFactory((Project)returnValue.getProject()).createExpressionFromText(returnValue.getText(), null);
        }
    }
}

