/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddAssertStatementFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.AddAssertStatementFix");
    private final String myText;

    public AddAssertStatementFix(@NotNull String text2) {
        this.myText = text2;
    }

    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"inspection.assert.quickfix", (Object[])new Object[]{this.myText});
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement prev;
        PsiElement element = descriptor.getPsiElement();
        PsiElement anchorElement = RefactoringUtil.getParentStatement(element, false);
        LOG.assertTrue(anchorElement != null);
        PsiElement tempParent = anchorElement.getParent();
        if (tempParent instanceof PsiForStatement && !PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)tempParent).getBody(), (PsiElement)anchorElement, (boolean)false)) {
            anchorElement = tempParent;
        }
        if ((prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchorElement)) instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn(prev) != null) {
            anchorElement = prev;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            String text2 = "assert " + this.myText + ";";
            PsiAssertStatement assertStatement = (PsiAssertStatement)factory.createStatementFromText(text2, null);
            PsiElement parent = anchorElement.getParent();
            if (parent instanceof PsiCodeBlock) {
                parent.addBefore((PsiElement)assertStatement, anchorElement);
            } else {
                RefactoringUtil.putStatementInLoopBody((PsiStatement)assertStatement, parent, anchorElement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.quickfix.assert.family", (Object[])new Object[0]);
    }
}

