/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AnnotateMethodFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(AnnotateMethodFix.class);
    private final String myAnnotation;
    private final String[] myAnnotationsToRemove;

    public AnnotateMethodFix(@NotNull String fqn, String ... annotationsToRemove) {
        this.myAnnotation = fqn;
        this.myAnnotationsToRemove = annotationsToRemove.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : annotationsToRemove;
        LOG.assertTrue(this.annotateSelf() || this.annotateOverriddenMethods(), (Object)"annotate method quick fix should not do nothing");
    }

    @NotNull
    public String getName() {
        return this.getFamilyName() + " " + this.getPreposition() + " '@" + ClassUtil.extractClassName((String)this.myAnnotation) + "'";
    }

    @NotNull
    protected String getPreposition() {
        return "with";
    }

    @NotNull
    public String getFamilyName() {
        if (this.annotateSelf()) {
            if (this.annotateOverriddenMethods()) {
                return InspectionsBundle.message((String)"inspection.annotate.overridden.method.and.self.quickfix.family.name", (Object[])new Object[0]);
            }
            return InspectionsBundle.message((String)"inspection.annotate.method.quickfix.family.name", (Object[])new Object[0]);
        }
        return InspectionsBundle.message((String)"inspection.annotate.overridden.method.quickfix.family.name", (Object[])new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (method == null) {
            return;
        }
        ArrayList<PsiMethod> toAnnotate = new ArrayList<PsiMethod>();
        if (this.annotateSelf()) {
            toAnnotate.add(method);
        }
        if (this.annotateOverriddenMethods() && !ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
                ReadAction.run(() -> {
                    if (psiMethod.isPhysical() && AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod, (String)this.myAnnotation) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)this.myAnnotation, (int)10) && !NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(psiMethod)) {
                        toAnnotate.add(psiMethod);
                    }
                });
            }
        }, "Searching for Overriding Methods", true, project)) {
            return;
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        for (PsiMethod psiMethod : toAnnotate) {
            this.annotateMethod(psiMethod);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)method.getContainingFile());
    }

    protected boolean annotateOverriddenMethods() {
        return false;
    }

    protected boolean annotateSelf() {
        return true;
    }

    private void annotateMethod(@NotNull PsiMethod method) {
        AddAnnotationPsiFix fix2 = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)method, PsiNameValuePair.EMPTY_ARRAY, this.myAnnotationsToRemove);
        fix2.invoke(method.getProject(), method.getContainingFile(), (PsiElement)method, (PsiElement)method);
    }
}

