/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AnnotatedElementVisitorBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnnotatedElementInspectionBase
extends LocalInspectionTool {
    public boolean myIgnoreInsideImports = true;

    @NotNull
    protected abstract List<String> getAnnotations();

    protected abstract void createProblem(@NotNull PsiReference var1, @NotNull PsiModifierListOwner var2, @NotNull List<PsiAnnotation> var3, @NotNull ProblemsHolder var4);

    protected boolean shouldProcessElement(@NotNull PsiModifierListOwner element) {
        return AnnotatedElementInspectionBase.isLibraryElement((PsiElement)element);
    }

    @NotNull
    public JPanel createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.ignore.inside.imports", new Object[0]), (InspectionProfileEntry)this, "myIgnoreInsideImports");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!this.isApplicable(holder.getFile(), holder.getProject())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new AnnotatedElementVisitorBase(this.myIgnoreInsideImports, this.getAnnotations()){

            @Override
            public void processAnnotatedTarget(@NotNull PsiReference reference, @NotNull PsiModifierListOwner annotatedTarget, @NotNull List<PsiAnnotation> annotations2) {
                if (AnnotatedElementInspectionBase.this.shouldProcessElement(annotatedTarget)) {
                    AnnotatedElementInspectionBase.this.createProblem(reference, annotatedTarget, annotations2, holder);
                }
            }
        };
    }

    private boolean isApplicable(@Nullable PsiFile file, @Nullable Project project) {
        if (file == null || project == null) {
            return false;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = file.getResolveScope();
        for (String annotation : this.getAnnotations()) {
            if (javaPsiFacade.findClass(annotation, scope) == null) continue;
            return true;
        }
        return false;
    }

    protected static String getPresentableText(@NotNull PsiElement psiElement) {
        return DeprecationInspectionBase.getPresentableName(psiElement);
    }

    private static boolean isLibraryElement(@NotNull PsiElement element) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        VirtualFile containingVirtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        return containingVirtualFile != null && ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
    }
}

