/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.apiUsage.ApiUsageVisitorBase;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastContextKt;

public abstract class AnnotatedElementVisitorBase
extends ApiUsageVisitorBase {
    private final boolean myIgnoreInsideImports;
    private final List<String> myAnnotations;

    public AnnotatedElementVisitorBase(boolean ignoreInsideImports, @NotNull List<String> annotations2) {
        this.myIgnoreInsideImports = ignoreInsideImports;
        this.myAnnotations = annotations2;
    }

    public abstract void processAnnotatedTarget(@NotNull PsiReference var1, @NotNull PsiModifierListOwner var2, @NotNull List<PsiAnnotation> var3);

    @Override
    public boolean shouldProcessReferences(@NotNull PsiElement element) {
        return !this.myIgnoreInsideImports || !AnnotatedElementVisitorBase.isInsideImportStatement(element);
    }

    private static boolean isInsideImportStatement(@NotNull PsiElement element) {
        return UastContextKt.getUastParentOfType((PsiElement)element, UImportStatement.class) != null;
    }

    @Override
    public void processReference(@NotNull PsiReference reference) {
        List annotations2;
        PsiModifierListOwner annotationsOwner = AnnotatedElementVisitorBase.resolveModifierListOwner(reference);
        if (annotationsOwner != null && !(annotations2 = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)annotationsOwner, this.myAnnotations, (boolean)false)).isEmpty()) {
            this.processAnnotatedTarget(reference, annotationsOwner, annotations2);
        }
    }

    @Override
    public void processConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass, @NotNull PsiMethod constructor) {
        List annotations2 = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)constructor, this.myAnnotations, (boolean)false);
        if (!annotations2.isEmpty()) {
            this.processAnnotatedTarget((PsiReference)instantiatedClass, (PsiModifierListOwner)constructor, annotations2);
        }
    }

    @Nullable
    private static PsiModifierListOwner resolveModifierListOwner(@NotNull PsiReference reference) {
        if (reference instanceof ResolvingHint && !((ResolvingHint)reference).canResolveTo(PsiModifierListOwner.class)) {
            return null;
        }
        PsiElement resolvedElement = reference.resolve();
        if (resolvedElement instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)resolvedElement;
        }
        return null;
    }
}

