/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AnonymousHasLambdaAlternativeInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(AnonymousHasLambdaAlternativeInspection.class);
    private static final AnonymousLambdaAlternative[] ALTERNATIVES = new AnonymousLambdaAlternative[]{new AnonymousLambdaAlternative("java.lang.ThreadLocal", "initialValue", "java.lang.ThreadLocal.withInitial($lambda$)", "ThreadLocal.withInitial()"), new AnonymousLambdaAlternative("java.lang.Thread", "run", "new java.lang.Thread($lambda$)", "new Thread(() -> {\u2026})")};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!JavaFeature.THREAD_LOCAL_WITH_INITIAL.isFeatureSupported(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                super.visitAnonymousClass(aClass);
                PsiExpressionList argumentList = aClass.getArgumentList();
                if (AnonymousCanBeLambdaInspection.isLambdaForm(aClass, Collections.emptySet()) && argumentList != null && argumentList.isEmpty()) {
                    PsiMethod method = aClass.getMethods()[0];
                    PsiClassType type2 = aClass.getBaseClassType();
                    AnonymousLambdaAlternative alternative = this.getAlternative(type2.resolve(), method);
                    if (alternative != null) {
                        PsiElement lBrace = aClass.getLBrace();
                        LOG.assertTrue(lBrace != null);
                        TextRange rangeInElement = new TextRange(0, lBrace.getStartOffsetInParent() + aClass.getStartOffsetInParent() - 1);
                        holder.registerProblem(aClass.getParent(), "Anonymous #ref #loc can be replaced with " + alternative.myReplacementMessage, ProblemHighlightType.LIKE_UNUSED_SYMBOL, rangeInElement, new LocalQuickFix[]{new ReplaceWithLambdaAlternativeFix(alternative)});
                    }
                }
            }

            @Contract(value="null, _ -> null")
            private AnonymousLambdaAlternative getAlternative(PsiClass type2, PsiMethod method) {
                if (type2 == null) {
                    return null;
                }
                for (AnonymousLambdaAlternative alternative : ALTERNATIVES) {
                    if (!alternative.myClassName.equals(type2.getQualifiedName()) || !alternative.myMethodName.equals(method.getName())) continue;
                    return alternative;
                }
                return null;
            }
        };
    }

    static class ReplaceWithLambdaAlternativeFix
    implements LocalQuickFix {
        @NotNull
        private final AnonymousLambdaAlternative myAlternative;

        ReplaceWithLambdaAlternativeFix(@NotNull AnonymousLambdaAlternative alternative) {
            this.myAlternative = alternative;
        }

        @Nls
        @NotNull
        public String getName() {
            return "Replace with " + this.myAlternative.myReplacementMessage;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace anonymous class with lambda alternative";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiAnonymousClass aClass = ((PsiNewExpression)element).getAnonymousClass();
            if (aClass == null) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length != 1) {
                return;
            }
            PsiMethod method = methods[0];
            if (method.getBody() == null) {
                return;
            }
            UnaryOperator replacer = lambda2 -> {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiElement replacement = element.replace((PsiElement)factory.createExpressionFromText(this.myAlternative.myLambdaAlternative, element));
                PsiElement[] lambdaPositions = PsiTreeUtil.collectElements((PsiElement)replacement, e -> e instanceof PsiReference && e.textMatches((CharSequence)"$lambda$"));
                LOG.assertTrue(lambdaPositions.length == 1);
                return (PsiLambdaExpression)lambdaPositions[0].replace((PsiElement)lambda2);
            };
            AnonymousCanBeLambdaInspection.generateLambdaByMethod(aClass, method, replacer, true);
        }
    }

    static final class AnonymousLambdaAlternative {
        final String myClassName;
        final String myMethodName;
        final String myLambdaAlternative;
        final String myReplacementMessage;

        AnonymousLambdaAlternative(String className, String methodName, String lambdaAlternative, String replacementMessage) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myLambdaAlternative = lambdaAlternative;
            this.myReplacementMessage = replacementMessage;
        }
    }
}

