/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMultiCatchFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetObjectCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CharsetCallMatcher[] MATCHERS = new CharsetCallMatcher[]{new CharsetConstructorMatcher("java.io.InputStreamReader", "java.io.InputStream", ""), new CharsetConstructorMatcher("java.io.OutputStreamWriter", "java.io.OutputStream", ""), new CharsetConstructorMatcher("java.lang.String", "byte[]", "int", "int", ""), new CharsetConstructorMatcher("java.lang.String", "byte[]", ""), new CharsetMethodMatcher("java.lang.String", "getBytes", new String[]{""}), new CharsetConstructorMatcher("java.util.Scanner", "java.io.InputStream", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.io.File", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.nio.file.Path", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.nio.channels.ReadableByteChannel", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.io.OutputStream", "boolean", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.lang.String", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.io.File", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.io.OutputStream", "boolean", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.lang.String", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.io.File", ""), new CharsetMethodMatcher("java.io.ByteArrayOutputStream", "toString", new String[]{""}), new CharsetMethodMatcher("java.net.URLDecoder", "decode", new String[]{"java.lang.String", ""}), new CharsetMethodMatcher("java.net.URLEncoder", "encode", new String[]{"java.lang.String", ""}), new CharsetMethodMatcher("java.nio.channels.Channels", "newReader", new String[]{"java.nio.channels.ReadableByteChannel", ""}), new CharsetMethodMatcher("java.nio.channels.Channels", "newWriter", new String[]{"java.nio.channels.WritableByteChannel", ""}), new CharsetMethodMatcher("java.util.Properties", "storeToXML", new String[]{"java.io.OutputStream", "java.lang.String", ""})};
    private static final Map<String, String> SUPPORTED_CHARSETS = ContainerUtil.immutableMapBuilder().put((Object)"US-ASCII", (Object)"US_ASCII").put((Object)"ASCII", (Object)"US_ASCII").put((Object)"ISO646-US", (Object)"US_ASCII").put((Object)"ISO-8859-1", (Object)"ISO_8859_1").put((Object)"UTF-8", (Object)"UTF_8").put((Object)"UTF8", (Object)"UTF_8").put((Object)"UTF-16BE", (Object)"UTF_16BE").put((Object)"UTF16BE", (Object)"UTF_16BE").put((Object)"UTF-16LE", (Object)"UTF_16LE").put((Object)"UTF16LE", (Object)"UTF_16LE").put((Object)"UTF-16", (Object)"UTF_16").put((Object)"UTF16", (Object)"UTF_16").build();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression call) {
                CharsetMatch match = StreamEx.of((Object[])MATCHERS).map(matcher -> matcher.extractCharsetMatch(call)).nonNull().findFirst().orElse(null);
                if (match == null) {
                    return;
                }
                String charsetString = this.getCharsetString(match.myStringCharset);
                if (charsetString == null) {
                    return;
                }
                String constantName = "StandardCharsets." + (String)SUPPORTED_CHARSETS.get(charsetString);
                holder.registerProblem((PsiElement)match.myStringCharset, InspectionsBundle.message((String)"inspection.charset.object.can.be.used.message", (Object[])new Object[]{constantName}), new LocalQuickFix[]{new CharsetObjectCanBeUsedFix(constantName)});
            }

            @Nullable
            private String getCharsetString(PsiExpression charsetExpression) {
                String charsetString = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(charsetExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)charsetExpression)), String.class);
                if (charsetString == null) {
                    return null;
                }
                charsetString = charsetString.toUpperCase(Locale.ENGLISH);
                if (!SUPPORTED_CHARSETS.containsKey(charsetString)) {
                    return null;
                }
                if (charsetExpression instanceof PsiLiteralExpression) {
                    return charsetString;
                }
                if (charsetExpression instanceof PsiReferenceExpression) {
                    String baseCharset;
                    String name = ((PsiReferenceExpression)charsetExpression).getReferenceName();
                    if (name == null) {
                        return null;
                    }
                    String baseName = name.replaceAll("[^A-Z0-9]", "").toLowerCase(Locale.ENGLISH);
                    if (!baseName.contains(baseCharset = charsetString.replaceAll("[^A-Z0-9]", "").toLowerCase(Locale.ENGLISH))) {
                        return null;
                    }
                    return charsetString;
                }
                return null;
            }
        };
    }

    static class CharsetObjectCanBeUsedFix
    implements LocalQuickFix {
        private final String myConstantName;

        CharsetObjectCanBeUsedFix(String constantName) {
            this.myConstantName = constantName;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.charset.object.can.be.used.fix.name", (Object[])new Object[]{this.myConstantName});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.charset.object.can.be.used.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiTryStatement tryStatement;
            PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiCallExpression.class);
            if (anchor == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = "java.nio.charset." + this.myConstantName;
            PsiReferenceExpression ref = (PsiReferenceExpression)ct.replaceAndRestoreComments((PsiElement)expression2, replacement);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
            while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null) {
                PsiCodeBlock tryBlock = tryStatement.getTryBlock();
                if (PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)anchor, (boolean)true)) {
                    for (PsiParameter parameter2 : tryStatement.getCatchBlockParameters()) {
                        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
                        for (PsiTypeElement element : typeElements) {
                            PsiType type2 = element.getType();
                            if (type2.equalsToText("java.io.UnsupportedEncodingException") || type2.equalsToText("java.io.IOException")) {
                                List unhandledExceptions = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
                                PsiResourceList resourceList = tryStatement.getResourceList();
                                if (resourceList != null) {
                                    Collection<PsiClassType> resourceExceptions = ExceptionUtil.collectUnhandledExceptions((PsiElement)resourceList, (PsiElement)resourceList);
                                    unhandledExceptions = StreamEx.of((Object[])new Collection[]{unhandledExceptions, resourceExceptions}).toFlatList(Function.identity());
                                }
                                if (unhandledExceptions.stream().noneMatch(ue -> ue.isAssignableFrom(type2) || type2.isAssignableFrom((PsiType)ue))) {
                                    if (parameter2.getType() instanceof PsiDisjunctionType) {
                                        DeleteMultiCatchFix.deleteCaughtExceptionType(element);
                                    } else {
                                        DeleteCatchFix.deleteCatch(parameter2);
                                    }
                                }
                                return;
                            }
                            if (!type2.equalsToText("java.lang.Exception") && !type2.equalsToText("java.lang.Throwable")) continue;
                            return;
                        }
                    }
                }
                anchor = tryStatement;
            }
        }
    }

    static class CharsetMatch {
        @NotNull
        final PsiExpression myStringCharset;
        @NotNull
        final PsiMethod myStringMethod;
        @NotNull
        final PsiMethod myCharsetMethod;

        CharsetMatch(@NotNull PsiExpression charset, @NotNull PsiMethod stringMethod, @NotNull PsiMethod charsetMethod) {
            this.myStringCharset = charset;
            this.myStringMethod = stringMethod;
            this.myCharsetMethod = charsetMethod;
        }
    }

    static class CharsetMethodMatcher
    extends CharsetCallMatcher {
        @NotNull
        private final String myMethodName;

        CharsetMethodMatcher(@NotNull String className, @NotNull String methodName, String ... parameters2) {
            super(className, parameters2);
            this.myMethodName = methodName;
        }

        @Override
        CharsetMatch extractCharsetMatch(PsiCallExpression call) {
            if (!(call instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)call;
            if (!this.myMethodName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressionCount() != this.myParameters.length) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (!this.checkMethod(method, "java.lang.String")) {
                return null;
            }
            return this.createMatch(method, argumentList);
        }
    }

    static class CharsetConstructorMatcher
    extends CharsetCallMatcher {
        CharsetConstructorMatcher(@NotNull String className, String ... parameters2) {
            super(className, parameters2);
        }

        @Override
        CharsetMatch extractCharsetMatch(PsiCallExpression call) {
            if (!(call instanceof PsiNewExpression)) {
                return null;
            }
            PsiNewExpression newExpression = (PsiNewExpression)call;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null || argumentList.getExpressionCount() != this.myParameters.length) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (!this.checkMethod(method, "java.lang.String") || !method.isConstructor()) {
                return null;
            }
            return this.createMatch(method, argumentList);
        }
    }

    static abstract class CharsetCallMatcher {
        @NotNull
        final String myClassName;
        @NotNull
        final String[] myParameters;
        final int myCharsetParameterIndex;

        CharsetCallMatcher(@NotNull String className, String ... parameters2) {
            this.myClassName = className;
            this.myParameters = parameters2;
            int index = -1;
            for (int i = 0; i < parameters2.length; ++i) {
                if (!parameters2[i].isEmpty()) continue;
                if (index == -1) {
                    index = i;
                    continue;
                }
                throw new IllegalArgumentException("Empty parameter type must be specified exactly once");
            }
            if (index == -1) {
                throw new IllegalArgumentException("No empty parameter type is specified");
            }
            this.myCharsetParameterIndex = index;
        }

        @Contract(value="null,_ -> false")
        final boolean checkMethod(PsiMethod method, @NotNull String charsetType) {
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !this.myClassName.equals(containingClass.getQualifiedName())) {
                return false;
            }
            PsiParameterList list = method.getParameterList();
            if (list.getParametersCount() != this.myParameters.length) {
                return false;
            }
            PsiParameter[] parameters2 = list.getParameters();
            for (int i = 0; i < this.myParameters.length; ++i) {
                PsiType parameterType = parameters2[i].getType();
                if (parameterType.equalsToText(this.myParameters[i].isEmpty() ? charsetType : this.myParameters[i])) continue;
                return false;
            }
            return true;
        }

        @Nullable
        final CharsetMatch createMatch(PsiMethod method, PsiExpressionList arguments) {
            PsiExpression argument = arguments.getExpressions()[this.myCharsetParameterIndex];
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiMethod[] candidates = method.isConstructor() ? aClass.getConstructors() : aClass.findMethodsByName(method.getName(), false);
            PsiMethod charsetMethod = Arrays.stream(candidates).filter(psiMethod -> this.checkMethod((PsiMethod)psiMethod, "java.nio.charset.Charset")).findFirst().orElse(null);
            if (charsetMethod == null) {
                return null;
            }
            return new CharsetMatch(argument, method, charsetMethod);
        }

        @Nullable
        abstract CharsetMatch extractCharsetMatch(PsiCallExpression var1);
    }
}

