/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClassGetClassInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!OBJECT_GET_CLASS.test(call)) {
                    return;
                }
                if (call.getParent() instanceof PsiExpressionStatement && !(call.getParent().getParent() instanceof PsiSwitchLabeledRuleStatement)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiType type2 = qualifier.getType();
                if (!(type2 instanceof PsiClassType)) {
                    return;
                }
                if (!((PsiClassType)type2).rawType().equalsToText("java.lang.Class")) {
                    return;
                }
                holder.registerProblem(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), InspectionsBundle.message((String)"inspection.class.getclass.message", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveGetClassCallFix(), new ReplaceWithClassClassFix()});
            }
        };
    }

    private static class ReplaceWithClassClassFix
    implements LocalQuickFix {
        private ReplaceWithClassClassFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.class.getclass.fix.replace.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)call, "java.lang.Class.class");
        }
    }

    private static class RemoveGetClassCallFix
    implements LocalQuickFix {
        private RemoveGetClassCallFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.class.getclass.fix.remove.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
        }
    }
}

