/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparatorCombinatorsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ComparatorCombinatorsInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiType type2 = lambda2.getFunctionalInterfaceType();
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 2 || !(type2 instanceof PsiClassType) || !((PsiClassType)type2).rawType().equalsToText("java.util.Comparator")) {
                    return;
                }
                String replacementText = ComparatorCombinatorsInspection.generateSimpleCombinator(lambda2, parameters2[0], parameters2[1]);
                if (replacementText != null) {
                    if (!LambdaUtil.isSafeLambdaReplacement((PsiLambdaExpression)lambda2, (String)replacementText)) {
                        return;
                    }
                    String qualifiedName = Objects.requireNonNull(StringUtil.substringBefore((String)replacementText, (String)"("));
                    String methodName = StringUtil.getShortName((String)qualifiedName);
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator." + methodName, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithComparatorFix("Comparator." + methodName)});
                    return;
                }
                if (lambda2.getBody() instanceof PsiCodeBlock) {
                    PsiStatement[] statements = ((PsiCodeBlock)lambda2.getBody()).getStatements();
                    List blocks = ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                    if (blocks == null) {
                        return;
                    }
                    String chainCombinator = ComparatorCombinatorsInspection.generateChainCombinator(blocks, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                    if (chainCombinator == null) {
                        return;
                    }
                    if (!LambdaUtil.isSafeLambdaReplacement((PsiLambdaExpression)lambda2, (String)chainCombinator)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator chain", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithComparatorFix("Comparator chain")});
                }
            }
        };
    }

    @Nullable(value="when failed to extract")
    private static List<ComparisonBlock> extractComparisonChain(@NotNull PsiStatement[] statements, @NotNull PsiVariable first, @NotNull PsiVariable second) {
        PsiStatement lastStmt;
        if (statements.length == 0) {
            return null;
        }
        ComparisonBlock firstBlock = ComparisonBlock.extractBlock(statements[0], first, second, null);
        if (firstBlock == null) {
            return null;
        }
        ArrayList<ComparisonBlock> blocks = new ArrayList<ComparisonBlock>();
        blocks.add(firstBlock);
        PsiVariable lastResult = firstBlock.getResult();
        int index = 1;
        while (index < statements.length - 1) {
            PsiStatement current = statements[index];
            if (ComparatorCombinatorsInspection.isNotZeroCheck(current, lastResult)) {
                int nextIndex = index + 1;
                if (nextIndex >= statements.length) {
                    return null;
                }
                PsiStatement next = statements[nextIndex];
                ComparisonBlock block = ComparisonBlock.extractBlock(next, first, second, lastResult);
                if (block == null) {
                    if (nextIndex == statements.length - 1) break;
                    return null;
                }
                blocks.add(block);
                index += 2;
                continue;
            }
            PsiStatement nextComparisonStmt = ComparatorCombinatorsInspection.extractZeroCheckedWay(current, lastResult);
            if (nextComparisonStmt != null) {
                ComparisonBlock block = ComparisonBlock.extractBlock(nextComparisonStmt, first, second, lastResult);
                if (block == null) {
                    return null;
                }
                blocks.add(block);
                if (block.getResult() != lastResult) {
                    lastResult = block.getResult();
                }
                ++index;
                continue;
            }
            return null;
        }
        if ((lastStmt = statements[statements.length - 1]) instanceof PsiReturnStatement) {
            PsiExpression returnExpr = ((PsiReturnStatement)lastStmt).getReturnValue();
            if (returnExpr == null) {
                return null;
            }
            if (ExpressionUtils.isReferenceTo(returnExpr, lastResult)) {
                return blocks;
            }
            ComparisonBlock lastBlock = ComparatorCombinatorsInspection.extractTernaryComparison(first, second, lastResult, returnExpr);
            if (lastBlock == null) {
                lastBlock = ComparisonBlock.extractBlock(returnExpr, first, second, lastResult);
            }
            if (lastBlock == null) {
                return null;
            }
            blocks.add(lastBlock);
            return blocks;
        }
        return null;
    }

    @Nullable
    private static ComparisonBlock extractTernaryComparison(@NotNull PsiVariable first, @NotNull PsiVariable second, PsiVariable lastResult, PsiExpression returnExpr) {
        PsiConditionalExpression ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)returnExpr, PsiConditionalExpression.class);
        if (ternary == null) {
            return null;
        }
        PsiExpression elseExpression2 = ternary.getElseExpression();
        PsiExpression thenExpression2 = ternary.getThenExpression();
        if (elseExpression2 == null || thenExpression2 == null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ternary.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression finalResult = ExpressionUtils.getValueComparedWithZero(binOp);
        boolean inverted = false;
        if (finalResult == null) {
            finalResult = ExpressionUtils.getValueComparedWithZero(binOp, JavaTokenType.NE);
            inverted = true;
        }
        if (!ExpressionUtils.isReferenceTo(finalResult, lastResult)) {
            return null;
        }
        if (!ExpressionUtils.isReferenceTo(inverted ? thenExpression2 : elseExpression2, lastResult)) {
            return null;
        }
        PsiMethodCallExpression lastComparison = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)(inverted ? elseExpression2 : thenExpression2), PsiMethodCallExpression.class);
        ComparisonBlock lastBlock = ComparisonBlock.extractBlock((PsiExpression)lastComparison, first, second, lastResult);
        if (lastBlock == null) {
            return null;
        }
        return lastBlock;
    }

    @Nullable
    private static PsiStatement extractZeroCheckedWay(@Nullable PsiStatement statement, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
        if (ifStatement == null || ifStatement.getElseBranch() != null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression maybeResult = ExpressionUtils.getValueComparedWithZero(binOp);
        if (!ExpressionUtils.isReferenceTo(maybeResult, last)) {
            return null;
        }
        return ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
    }

    private static boolean isNotZeroCheck(@NotNull PsiStatement statement, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
        if (ifStatement == null || ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return false;
        }
        if (!ExpressionUtils.isReferenceTo(ExpressionUtils.getValueComparedWithZero(binaryExpression, JavaTokenType.NE), last)) {
            return false;
        }
        PsiStatement thenStmt = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenStmt instanceof PsiReturnStatement)) {
            return false;
        }
        return ExpressionUtils.isReferenceTo(((PsiReturnStatement)thenStmt).getReturnValue(), last);
    }

    @NotNull
    private static String generateComparison(@NotNull String methodName, @Nullable PsiType type2, @NotNull String varName, @NotNull PsiExpression expression2, @NotNull PsiVariable exprVariable) {
        String lambdaExpr = ComparatorCombinatorsInspection.getExpressionReplacingReferences(expression2, varName, exprVariable);
        String parameter2 = type2 == null ? varName : "(" + type2.getCanonicalText() + " " + varName + ")";
        return methodName + "(" + parameter2 + "->" + lambdaExpr + ")";
    }

    @Nullable
    private static String generateSimpleCombinator(PsiLambdaExpression lambda2, PsiParameter leftVar, PsiParameter rightVar) {
        String text2;
        PsiExpression left;
        PsiExpression body2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
        String methodName = null;
        if (body2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body2;
            if (MethodCallUtils.isCompareToCall(methodCall)) {
                left = methodCall.getMethodExpression().getQualifierExpression();
                PsiExpression right = (PsiExpression)ArrayUtil.getFirstElement((Object[])methodCall.getArgumentList().getExpressions());
                if (ExpressionUtils.isReferenceTo(left, (PsiVariable)leftVar) && ExpressionUtils.isReferenceTo(right, (PsiVariable)rightVar)) {
                    methodName = "naturalOrder";
                } else if (ExpressionUtils.isReferenceTo(right, (PsiVariable)leftVar) && ExpressionUtils.isReferenceTo(left, (PsiVariable)rightVar)) {
                    methodName = "reverseOrder";
                } else if (ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, left, (PsiVariable)rightVar, right)) {
                    methodName = "comparing";
                }
            } else {
                PrimitiveComparison comparison = PrimitiveComparison.from(methodCall);
                if (comparison == null) {
                    return null;
                }
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (!ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, args[0], (PsiVariable)rightVar, args[1])) {
                    return null;
                }
                methodName = comparison.getMethodName();
                left = comparison.getKeyExtractor();
            }
        } else if (body2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)body2;
            if (!binOp.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                return null;
            }
            left = binOp.getLOperand();
            PsiType type2 = left.getType();
            if (type2 == null) {
                return null;
            }
            if (ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, left, (PsiVariable)rightVar, binOp.getROperand())) {
                methodName = ComparatorCombinatorsInspection.getComparingMethodName(type2.getCanonicalText());
            }
        } else {
            return null;
        }
        if (methodName == null) {
            return null;
        }
        if (!methodName.startsWith("comparing")) {
            text2 = "java.util.Comparator." + methodName + "()";
        } else {
            String parameterName = leftVar.getName();
            PsiTypeElement typeElement = leftVar.getTypeElement();
            String parameterDeclaration = typeElement == null ? parameterName : "(" + typeElement.getText() + " " + parameterName + ")";
            text2 = "java.util.Comparator." + methodName + "(" + parameterDeclaration + " -> " + left.getText() + ")";
        }
        return text2;
    }

    @Nullable
    private static String generateChainCombinator(@NotNull List<ComparisonBlock> blocks, @NotNull PsiVariable firstVar, @NotNull PsiVariable secondVar) {
        if (blocks.size() < 2) {
            return null;
        }
        ComparisonBlock first = blocks.get(0);
        StringBuilder builder = new StringBuilder();
        PsiType type2 = secondVar.getType();
        String name = ComparatorCombinatorsInspection.suggestVarName(firstVar);
        if (name == null) {
            return null;
        }
        PsiExpression firstKey = first.getKey();
        String firstMethodName = ComparatorCombinatorsInspection.getComparingMethodName(firstKey.getType(), true);
        if (firstMethodName == null) {
            return null;
        }
        builder.append("java.util.Comparator").append(".").append(ComparatorCombinatorsInspection.generateComparison(firstMethodName, type2, name, firstKey, secondVar));
        for (int i = 1; i < blocks.size(); ++i) {
            ComparisonBlock block = blocks.get(i);
            PsiExpression blockKey = block.getKey();
            String comparatorMethodName = ComparatorCombinatorsInspection.getComparingMethodName(blockKey.getType(), false);
            if (comparatorMethodName == null) {
                return null;
            }
            builder.append(".").append(ComparatorCombinatorsInspection.generateComparison(comparatorMethodName, null, name, blockKey, secondVar));
        }
        return builder.toString();
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static String getComparingMethodName(@Nullable PsiType exprType, boolean first) {
        if (exprType == null) {
            return null;
        }
        String name = ComparatorCombinatorsInspection.getComparingMethodName(exprType.getCanonicalText(), first);
        if (name != null) {
            return name;
        }
        if (InheritanceUtil.isInheritor((PsiType)exprType, (String)"java.lang.Comparable")) {
            return first ? "comparing" : "thenComparing";
        }
        return null;
    }

    @Nullable
    private static String suggestVarName(@NotNull PsiVariable variable) {
        String[] names;
        String name = variable.getName();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
        SuggestedNameInfo nameCandidate = null;
        if (name != null) {
            if (name.length() > 1 && name.endsWith("1")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, name.substring(0, name.length() - 1), null, variable.getType(), true);
            } else if (name.equals("first")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, variable.getType(), true);
            }
        }
        if (nameCandidate != null && (names = codeStyleManager.suggestUniqueVariableName(nameCandidate, (PsiElement)variable, (boolean)true).names).length > 0) {
            return names[0];
        }
        return name;
    }

    private static String getExpressionReplacingReferences(@NotNull PsiExpression expression2, @NotNull String varName, @NotNull PsiVariable exprVariable) {
        PsiExpression copy = (PsiExpression)expression2.copy();
        ReferencesSearch.search((PsiElement)exprVariable, (SearchScope)new LocalSearchScope((PsiElement)copy)).forEach(reference -> {
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)reference.getElement(), PsiReferenceExpression.class);
            if (ref == null) {
                return;
            }
            ExpressionUtils.bindReferenceTo(ref, varName);
        });
        return copy.getText();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type2) {
        return ComparatorCombinatorsInspection.getComparingMethodName(type2, true);
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type2, boolean first) {
        if (type2 == null) {
            return null;
        }
        switch (PsiTypesUtil.unboxIfPossible((String)type2)) {
            case "int": 
            case "short": 
            case "byte": 
            case "char": {
                return first ? "comparingInt" : "thenComparingInt";
            }
            case "long": {
                return first ? "comparingLong" : "thenComparingLong";
            }
            case "double": {
                return first ? "comparingDouble" : "thenComparingDouble";
            }
        }
        return null;
    }

    @Contract(value="_, null, _, _ -> false; _, !null, _, null -> false")
    private static boolean areEquivalent(PsiVariable leftVar, @Nullable PsiExpression left, PsiVariable rightVar, @Nullable PsiExpression right) {
        if (left == null || right == null) {
            return false;
        }
        if (VariableAccessUtils.variableIsUsed(rightVar, (PsiElement)left) || VariableAccessUtils.variableIsUsed(leftVar, (PsiElement)right)) {
            return false;
        }
        PsiExpression copy = (PsiExpression)right.copy();
        PsiElement[] rightRefs = PsiTreeUtil.collectElements((PsiElement)copy, e -> e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).resolve() == rightVar);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)left.getProject());
        String paramName = leftVar.getName();
        if (paramName == null) {
            return false;
        }
        for (PsiElement ref : rightRefs) {
            PsiElement nameElement = ((PsiReferenceExpression)ref).getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            nameElement.replace((PsiElement)factory.createIdentifier(paramName));
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, copy);
    }

    static class ReplaceWithComparatorFix
    implements LocalQuickFix {
        private final String myMessage;

        ReplaceWithComparatorFix(String message2) {
            this.myMessage = message2;
        }

        @Nls
        @NotNull
        public String getName() {
            return "Replace with " + this.myMessage;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Simplify comparator using Comparator static methods";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiStatement[] statements;
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 2) {
                return;
            }
            if (lambda2.getBody() instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambda2.getBody()).getStatements()).length > 1) {
                List chain = ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                if (chain == null) {
                    return;
                }
                String code = ComparatorCombinatorsInspection.generateChainCombinator(chain, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                if (code == null) {
                    return;
                }
                PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)lambda2, code);
                RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
                CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result));
                return;
            }
            String text2 = ComparatorCombinatorsInspection.generateSimpleCombinator(lambda2, parameters2[0], parameters2[1]);
            if (text2 == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression replacement = factory.createExpressionFromText(text2, element);
            PsiMethodCallExpression result = (PsiMethodCallExpression)lambda2.replace((PsiElement)replacement);
            ReplaceWithComparatorFix.normalizeLambda((PsiExpression)ArrayUtil.getFirstElement((Object[])result.getArgumentList().getExpressions()), factory);
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)result));
        }

        private static void normalizeLambda(PsiExpression expression2, PsiElementFactory factory) {
            PsiParameter parameter2;
            String name;
            if (!(expression2 instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            if (LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2) == lambda2 && (name = ComparatorCombinatorsInspection.suggestVarName((PsiVariable)(parameter2 = parameters2[0]))) != null) {
                Collection references = PsiTreeUtil.collectElementsOfType((PsiElement)body2, (Class[])new Class[]{PsiReferenceExpression.class});
                ((StreamEx)StreamEx.of((Collection)references).filter(ref -> ref.isReferenceTo((PsiElement)parameter2))).map(PsiJavaCodeReferenceElement::getReferenceNameElement).nonNull().forEach(nameElement -> nameElement.replace((PsiElement)factory.createIdentifier(name)));
                parameter2.setName(name);
            }
        }
    }

    private static class PrimitiveComparison {
        @NotNull
        private final PsiExpression myKeyExtractor;
        @NotNull
        private final String myMethodName;

        private PrimitiveComparison(@NotNull PsiExpression extractor, @NotNull String name) {
            this.myKeyExtractor = extractor;
            this.myMethodName = name;
        }

        @NotNull
        public PsiExpression getKeyExtractor() {
            return this.myKeyExtractor;
        }

        @NotNull
        public String getMethodName() {
            return this.myMethodName;
        }

        @Nullable
        private static PrimitiveComparison from(PsiMethodCallExpression methodCall) {
            String className;
            PsiClass containingClass;
            PsiMethod method = methodCall.resolveMethod();
            if (method != null && method.getName().equals("compare") && (containingClass = method.getContainingClass()) != null && (className = containingClass.getQualifiedName()) != null) {
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return null;
                }
                PsiExpression keyExtractor = args[0];
                String methodName = ComparatorCombinatorsInspection.getComparingMethodName(className);
                if (methodName == null) {
                    return null;
                }
                return new PrimitiveComparison(keyExtractor, methodName);
            }
            return null;
        }
    }

    private static class ComparisonBlock {
        private final PsiExpression myKey;
        private final PsiVariable myResult;

        private ComparisonBlock(PsiExpression key2, PsiVariable result) {
            this.myKey = key2;
            this.myResult = result;
        }

        public PsiExpression getKey() {
            return this.myKey;
        }

        public PsiVariable getResult() {
            return this.myResult;
        }

        @Nullable
        static ComparisonBlock extractBlock(@NotNull PsiStatement statement, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiVariable previousResult) {
            if (statement instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
                PsiElement[] elements = declaration2.getDeclaredElements();
                if (elements.length == 0) {
                    return null;
                }
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
                if (variable == null) {
                    return null;
                }
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
                return ComparisonBlock.extractBlock(initializer, firstParam, secondParam, (PsiVariable)variable);
            }
            if (previousResult != null && statement instanceof PsiExpressionStatement) {
                PsiExpression expr = ExpressionUtils.getAssignmentTo((PsiElement)((PsiExpressionStatement)statement).getExpression(), previousResult);
                return ComparisonBlock.extractBlock(expr, firstParam, secondParam, previousResult);
            }
            return null;
        }

        @Contract(value="null, _, _, _ -> null")
        @Nullable
        private static ComparisonBlock extractBlock(@Nullable PsiExpression expr, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @NotNull PsiVariable variable) {
            PsiExpression first = null;
            PsiExpression second = null;
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                PsiExpression[] parameters2 = call.getArgumentList().getExpressions();
                if (PrimitiveComparison.from(call) != null) {
                    first = parameters2[0];
                    second = parameters2[1];
                } else if (MethodCallUtils.isCompareToCall(call)) {
                    first = call.getMethodExpression().getQualifierExpression();
                    second = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                }
            } else if (expr instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)expr;
                if (binOp.getOperationTokenType() != JavaTokenType.MINUS) {
                    return null;
                }
                first = binOp.getLOperand();
                if (ComparatorCombinatorsInspection.getComparingMethodName(first.getType(), true) == null) {
                    return null;
                }
                second = binOp.getROperand();
            }
            if (first == null || second == null) {
                return null;
            }
            if (!ComparisonBlock.usagesAreAllowed(firstParam, secondParam, first, second)) {
                return null;
            }
            if (!ComparisonBlock.keyAccessEquivalent(firstParam, secondParam, first, second)) {
                return null;
            }
            return new ComparisonBlock(second, variable);
        }

        private static boolean keyAccessEquivalent(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, PsiExpression first, PsiExpression second) {
            String secondParamName = secondParam.getName();
            if (secondParamName == null) {
                return false;
            }
            return ComparatorCombinatorsInspection.areEquivalent(firstParam, first, secondParam, second);
        }

        private static boolean usagesAreAllowed(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiExpression firstExpr, @Nullable PsiExpression secondExpr) {
            return VariableAccessUtils.variableIsUsed(firstParam, (PsiElement)firstExpr) && VariableAccessUtils.variableIsUsed(secondParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed(firstParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed(secondParam, (PsiElement)firstExpr);
        }
    }
}

