/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalBreakInInfiniteLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean noConversionToDoWhile = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop.no.conversion.with.do.while", (Object[])new Object[0]), "noConversionToDoWhile");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitWhileStatement(PsiWhileStatement statement) {
                this.visitLoop((PsiLoopStatement)statement);
            }

            public void visitDoWhileStatement(PsiDoWhileStatement statement) {
                this.visitLoop((PsiLoopStatement)statement);
            }

            public void visitForStatement(PsiForStatement statement) {
                this.visitLoop((PsiLoopStatement)statement);
            }

            private void visitLoop(@NotNull PsiLoopStatement loopStatement) {
                LocalQuickFix[] fixes;
                PsiElement keyword = ConditionalBreakInInfiniteLoopInspection.getKeyword(loopStatement);
                if (keyword == null) {
                    return;
                }
                Context context = Context.from(loopStatement, ConditionalBreakInInfiniteLoopInspection.this.noConversionToDoWhile);
                if (context == null) {
                    return;
                }
                if (context.myConditionInTheBeginning) {
                    fixes = new LocalQuickFix[]{new LoopTransformationFix()};
                } else {
                    SetInspectionOptionFix setInspectionOptionFix = new SetInspectionOptionFix((LocalInspectionTool)ConditionalBreakInInfiniteLoopInspection.this, "noConversionToDoWhile", InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop.no.conversion.with.do.while", (Object[])new Object[0]), true);
                    fixes = new LocalQuickFix[]{new LoopTransformationFix(), setInspectionOptionFix};
                }
                holder.registerProblem(keyword, InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop.description", (Object[])new Object[0]), fixes);
            }
        };
    }

    @Nullable
    private static PsiElement getKeyword(@NotNull PsiLoopStatement loopStatement) {
        if (loopStatement instanceof PsiWhileStatement || loopStatement instanceof PsiForStatement) {
            return loopStatement.getFirstChild();
        }
        return ((PsiDoWhileStatement)loopStatement).getWhileKeyword();
    }

    private static class LoopTransformationFix
    implements LocalQuickFix {
        private LoopTransformationFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.conditional.break.in.infinite.loop", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiLoopStatement.class);
            if (loop == null) {
                return;
            }
            Context context = Context.from(loop, false);
            if (context == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String negated = BoolUtils.getNegatedExpressionText(context.myCondition, ct);
            ct.delete((PsiElement)context.myConditionStatement);
            String loopText = context.myConditionInTheBeginning ? "while(" + negated + ")" + ct.text((PsiElement)context.myLoopBody) : "do" + ct.text((PsiElement)context.myLoopBody) + "while(" + negated + ");";
            ct.replaceAndRestoreComments((PsiElement)context.myLoopStatement, loopText);
        }
    }

    private static class Context {
        @NotNull
        final PsiLoopStatement myLoopStatement;
        @NotNull
        final PsiStatement myLoopBody;
        @NotNull
        final PsiExpression myCondition;
        @NotNull
        final PsiStatement myConditionStatement;
        final boolean myConditionInTheBeginning;

        Context(@NotNull PsiLoopStatement loopStatement, @NotNull PsiStatement loopBody, @NotNull PsiExpression condition2, @NotNull PsiStatement statement, boolean conditionInTheBeginning) {
            this.myLoopStatement = loopStatement;
            this.myLoopBody = loopBody;
            this.myCondition = condition2;
            this.myConditionStatement = statement;
            this.myConditionInTheBeginning = conditionInTheBeginning;
        }

        @Nullable
        static Context from(@NotNull PsiLoopStatement loopStatement, boolean noConversionToDoWhile) {
            if (!ControlFlowUtils.isEndlessLoop(loopStatement)) {
                return null;
            }
            PsiStatement body2 = loopStatement.getBody();
            if (body2 == null) {
                return null;
            }
            Object[] statements = ControlFlowUtils.unwrapBlock(body2);
            if (statements.length < 2) {
                return null;
            }
            if (((StreamEx)StreamEx.ofTree((Object)body2, el -> StreamEx.of((Object[])el.getChildren())).select(PsiBreakStatement.class).filter(stmt -> ControlFlowUtils.statementBreaksLoop((PsiStatement)stmt, loopStatement))).count() != 1L) {
                return null;
            }
            PsiStatement first = statements[0];
            PsiExpression firstBreakCondition = Context.extractBreakCondition(first, loopStatement);
            if (firstBreakCondition != null) {
                return new Context(loopStatement, body2, firstBreakCondition, first, true);
            }
            if (noConversionToDoWhile) {
                return null;
            }
            PsiStatement last = statements[statements.length - 1];
            PsiExpression lastBreakCondition = Context.extractBreakCondition(last, loopStatement);
            if (lastBreakCondition != null) {
                if (StreamEx.of((Object[])statements).flatMap(statement -> StreamEx.ofTree((Object)statement, el -> StreamEx.of((Object[])el.getChildren()))).anyMatch(e -> e instanceof PsiContinueStatement && ((PsiContinueStatement)e).findContinuedStatement() == loopStatement)) {
                    return null;
                }
                boolean variablesInLoop = VariableAccessUtils.collectUsedVariables((PsiElement)lastBreakCondition).stream().anyMatch(var -> PsiTreeUtil.isAncestor((PsiElement)loopStatement, (PsiElement)var, (boolean)false));
                if (variablesInLoop) {
                    return null;
                }
                return new Context(loopStatement, body2, lastBreakCondition, last, false);
            }
            return null;
        }

        @Nullable
        private static PsiExpression extractBreakCondition(@NotNull PsiStatement statement, @NotNull PsiLoopStatement loopStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
            if (ifStatement == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (!ControlFlowUtils.statementBreaksLoop(ControlFlowUtils.stripBraces(thenBranch), loopStatement)) {
                return null;
            }
            return ifStatement.getCondition();
        }
    }
}

