/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class DeprecatedIsStillUsedInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new JavaElementVisitor(){

            public void visitIdentifier(PsiIdentifier identifier) {
                PsiElement parent = identifier.getParent();
                if (parent instanceof PsiMember && parent instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getNameIdentifier() == identifier) {
                    DeprecatedIsStillUsedInspection.checkMember((PsiMember)parent, identifier, holder);
                }
                super.visitIdentifier(identifier);
            }
        };
    }

    private static void checkMember(@NotNull PsiMember member, @NotNull PsiIdentifier identifier, @NotNull ProblemsHolder holder) {
        if (!(member instanceof PsiDocCommentOwner) || !DeprecatedIsStillUsedInspection.isDeprecated((PsiDocCommentOwner)member)) {
            return;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)member.getProject());
        String name = member.getName();
        if (name != null && DeprecatedIsStillUsedInspection.hasUsages((PsiElement)member, name, searchHelper, member.getResolveScope())) {
            holder.registerProblem((PsiElement)identifier, "Deprecated member '" + name + "' is still used", new LocalQuickFix[0]);
        }
    }

    private static boolean isDeprecated(PsiDocCommentOwner element) {
        return element.isDeprecated();
    }

    private static boolean hasUsages(@NotNull PsiElement element, @NotNull String name, @NotNull PsiSearchHelper psiSearchHelper, @NotNull GlobalSearchScope searchScope) {
        PsiSearchHelper.SearchCostResult cheapEnough = psiSearchHelper.isCheapEnoughToSearch(name, searchScope, null, null);
        if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES || cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)element, (SearchScope)searchScope, (boolean)false).anyMatch(reference -> {
            PsiElement referenceElement = reference.getElement();
            return !DeprecationInspectionBase.isElementInsideDeprecated(referenceElement) && !PsiUtil.isInsideJavadocComment((PsiElement)referenceElement);
        });
    }
}

