/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnhancedSwitchMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final SwitchConversion[] ourInspections = new SwitchConversion[]{EnhancedSwitchMigrationInspection::inspectReturningSwitch, EnhancedSwitchMigrationInspection::inspectVariableAssigningSwitch, EnhancedSwitchMigrationInspection::inspectReplacementWithStatement};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!HighlightUtil.Feature.ENHANCED_SWITCH.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitSwitchStatement(PsiSwitchStatement statement) {
                SwitchReplacer replacer = EnhancedSwitchMigrationInspection.findSwitchReplacer(statement);
                if (replacer == null) {
                    return;
                }
                PsiElement switchKeyword = statement.getFirstChild();
                holder.registerProblem(switchKeyword, InspectionsBundle.message((String)"inspection.switch.expression.migration.inspection.switch.description", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithSwitchExpressionFix(replacer.getType())});
            }
        };
    }

    @Nullable
    private static SwitchReplacer runInspections(PsiStatement statement, PsiExpression condition2, boolean isExhaustive, List<? extends OldSwitchStatementBranch> branches) {
        for (SwitchConversion inspection : ourInspections) {
            SwitchReplacer replacer = inspection.suggestReplacer(statement, condition2, branches, isExhaustive);
            if (replacer == null) continue;
            return replacer;
        }
        return null;
    }

    private static OldSwitchStatementBranch addBranch(List<OldSwitchStatementBranch> branches, PsiStatement[] statements, int unmatchedCaseIndex, int endIndexExcl, boolean isFallthrough, PsiBreakStatement current) {
        PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statements[unmatchedCaseIndex];
        PsiStatement[] branchStatements = Arrays.copyOfRange(statements, unmatchedCaseIndex + 1, endIndexExcl);
        OldSwitchStatementBranch branch = new OldSwitchStatementBranch(isFallthrough, branchStatements, labelStatement, current);
        branches.add(branch);
        return branch;
    }

    @Nullable
    private static List<OldSwitchStatementBranch> extractBranches(@NotNull PsiCodeBlock body2) {
        ArrayList<OldSwitchStatementBranch> branches = new ArrayList<OldSwitchStatementBranch>();
        PsiStatement[] statements = body2.getStatements();
        int unmatchedCaseIndex = -1;
        OldSwitchStatementBranch previousBranch = null;
        int length = statements.length;
        for (int i = 0; i < length; ++i) {
            PsiStatement current = statements[i];
            if (current instanceof PsiSwitchLabelStatement) {
                if (unmatchedCaseIndex != -1) {
                    boolean isFallthrough = i != 0 && ControlFlowUtils.statementMayCompleteNormally(statements[i - 1]);
                    OldSwitchStatementBranch newBranch = EnhancedSwitchMigrationInspection.addBranch(branches, statements, unmatchedCaseIndex, i, isFallthrough, null);
                    newBranch.myPreviousSwitchBranch = previousBranch;
                    previousBranch = newBranch;
                }
                unmatchedCaseIndex = i;
                continue;
            }
            if (current instanceof PsiBreakStatement) {
                if (unmatchedCaseIndex == -1) {
                    return null;
                }
                OldSwitchStatementBranch newBranch = EnhancedSwitchMigrationInspection.addBranch(branches, statements, unmatchedCaseIndex, i, false, (PsiBreakStatement)current);
                newBranch.myPreviousSwitchBranch = previousBranch;
                previousBranch = newBranch;
                unmatchedCaseIndex = -1;
                continue;
            }
            if (!(current instanceof PsiSwitchLabeledRuleStatement)) continue;
            return null;
        }
        if (unmatchedCaseIndex != -1) {
            OldSwitchStatementBranch branch = EnhancedSwitchMigrationInspection.addBranch(branches, statements, unmatchedCaseIndex, statements.length, false, null);
            branch.myPreviousSwitchBranch = previousBranch;
        }
        return branches;
    }

    @Nullable
    private static PsiLocalVariable getVariable(PsiDeclarationStatement declaration2) {
        if (declaration2 == null) {
            return null;
        }
        PsiElement[] declaredElements = declaration2.getDeclaredElements();
        if (declaredElements.length != 1) {
            return null;
        }
        return (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
    }

    @Nullable
    public static SwitchReplacer findSwitchReplacer(PsiSwitchStatement switchStatement) {
        PsiExpression expression2 = switchStatement.getExpression();
        if (expression2 == null) {
            return null;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return null;
        }
        List<OldSwitchStatementBranch> branches = EnhancedSwitchMigrationInspection.extractBranches(body2);
        if (branches == null || branches.isEmpty()) {
            return null;
        }
        boolean isExhaustive = EnhancedSwitchMigrationInspection.isExhaustiveSwitch(branches, expression2);
        return EnhancedSwitchMigrationInspection.runInspections((PsiStatement)switchStatement, expression2, isExhaustive, branches);
    }

    @Nullable
    private static PsiSwitchBlock generateEnhancedSwitch(@NotNull PsiStatement statementToReplace, PsiExpression expressionBeingSwitched, List<SwitchExpressionBranch> newBranches, CommentTracker mainCommentTracker, boolean isExpr) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statementToReplace.getProject());
        mainCommentTracker.markUnchanged(expressionBeingSwitched);
        if (!(statementToReplace instanceof PsiSwitchStatement)) {
            return null;
        }
        PsiCodeBlock body2 = ((PsiSwitchStatement)statementToReplace).getBody();
        if (body2 == null) {
            return null;
        }
        for (PsiStatement statement : body2.getStatements()) {
            mainCommentTracker.markUnchanged(statement);
        }
        StringBuilder sb = new StringBuilder().append("switch(").append(expressionBeingSwitched.getText()).append("){\n");
        int size = newBranches.size();
        ArrayList<CommentTracker> branchTrackers = new ArrayList<CommentTracker>(newBranches.size());
        for (int i = 0; i < size; ++i) {
            SwitchExpressionBranch newBranch = newBranches.get(i);
            CommentTracker ct = new CommentTracker();
            branchTrackers.add(ct);
            sb.append(newBranch.generate(ct));
            if (i == size - 1) continue;
            sb.append("\n");
        }
        sb.append("\n}");
        PsiSwitchBlock switchBlock = isExpr ? (PsiSwitchBlock)factory.createExpressionFromText(sb.toString(), (PsiElement)statementToReplace) : (PsiSwitchBlock)factory.createStatementFromText(sb.toString(), (PsiElement)statementToReplace);
        PsiCodeBlock resultBody = switchBlock.getBody();
        PsiSwitchLabeledRuleStatement[] labeledStatements = (PsiSwitchLabeledRuleStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)resultBody, PsiSwitchLabeledRuleStatement.class);
        if (labeledStatements == null || labeledStatements.length != size) {
            return switchBlock;
        }
        for (int i = 0; i < labeledStatements.length; ++i) {
            PsiSwitchLabeledRuleStatement labeledStatement = labeledStatements[i];
            ((CommentTracker)branchTrackers.get(i)).insertCommentsBefore((PsiElement)labeledStatement);
        }
        return switchBlock;
    }

    private static boolean isExhaustiveSwitch(List<OldSwitchStatementBranch> branches, PsiExpression expressionBeingSwitched) {
        for (OldSwitchStatementBranch branch : branches) {
            if (!branch.isDefault()) continue;
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expressionBeingSwitched.getType());
        if (aClass == null || !aClass.isEnum()) {
            return false;
        }
        Set names = StreamEx.of((Object[])aClass.getAllFields()).select(PsiEnumConstant.class).map(PsiNamedElement::getName).toSet();
        for (OldSwitchStatementBranch branch : branches) {
            for (PsiExpression caseValue : branch.getCurrentBranchCaseExpressions()) {
                PsiEnumConstant enumConstant;
                PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)caseValue, PsiReferenceExpression.class);
                if (reference == null || (enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)reference.resolve(), PsiEnumConstant.class)) == null) continue;
                names.remove(enumConstant.getName());
            }
        }
        return names.isEmpty();
    }

    private static boolean isConvertibleBranch(OldSwitchStatementBranch branch) {
        int length = branch.getStatements().length;
        if (length == 0) {
            return branch.isFallthrough();
        }
        return length == 1 && !branch.isFallthrough();
    }

    @Nullable
    private static SwitchReplacer inspectReturningSwitch(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<? extends OldSwitchStatementBranch> branches, boolean isExhaustive) {
        PsiReturnStatement returnAfterSwitch = (PsiReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class), PsiReturnStatement.class);
        if (returnAfterSwitch == null && !isExhaustive) {
            return null;
        }
        ArrayList<SwitchExpressionBranch> newBranches = new ArrayList<SwitchExpressionBranch>();
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            SwitchRuleResult result;
            if (!EnhancedSwitchMigrationInspection.isConvertibleBranch(oldSwitchStatementBranch)) {
                return null;
            }
            if (oldSwitchStatementBranch.isFallthrough()) continue;
            PsiStatement[] statements = oldSwitchStatementBranch.getStatements();
            if (statements.length != 1) {
                return null;
            }
            PsiReturnStatement returnStmt = (PsiReturnStatement)ObjectUtils.tryCast((Object)statements[0], PsiReturnStatement.class);
            if (returnStmt == null) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)statements[0], PsiThrowStatement.class);
                if (throwStatement == null) {
                    return null;
                }
                result = new SwitchStatementBranch(new PsiStatement[]{throwStatement});
            } else {
                PsiExpression returnExpr = returnStmt.getReturnValue();
                if (returnExpr == null) {
                    return null;
                }
                result = new SwitchRuleExpressionResult(returnExpr);
            }
            newBranches.add(new SwitchExpressionBranch(oldSwitchStatementBranch.isDefault(), oldSwitchStatementBranch.getCaseExpressions(), result, oldSwitchStatementBranch.getUsedElements()));
        }
        if (!isExhaustive) {
            PsiExpression returnExpr = returnAfterSwitch.getReturnValue();
            if (returnExpr == null) {
                return null;
            }
            newBranches.add(new SwitchExpressionBranch(true, Collections.emptyList(), new SwitchRuleExpressionResult(returnExpr), Collections.emptyList()));
        }
        return new ReturningSwitchReplacer(statement, expressionBeingSwitched, newBranches, returnAfterSwitch);
    }

    @Nullable
    private static SwitchReplacer inspectVariableAssigningSwitch(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<? extends OldSwitchStatementBranch> branches, boolean isExhaustive) {
        PsiElement parent = statement.getParent();
        Object anchor = parent instanceof PsiLabeledStatement ? parent : statement;
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.getPrevSiblingOfType((PsiElement)anchor, PsiStatement.class), PsiDeclarationStatement.class);
        PsiLocalVariable variable = EnhancedSwitchMigrationInspection.getVariable(declaration2);
        if (variable == null) {
            return null;
        }
        ArrayList<SwitchExpressionBranch> newBranches = new ArrayList<SwitchExpressionBranch>();
        PsiExpression initializer = variable.getInitializer();
        if (!isExhaustive && initializer == null) {
            return null;
        }
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            SwitchRuleResult result;
            if (!EnhancedSwitchMigrationInspection.isConvertibleBranch(oldSwitchStatementBranch)) {
                return null;
            }
            if (oldSwitchStatementBranch.isFallthrough() && oldSwitchStatementBranch.getStatements().length == 0) continue;
            PsiStatement first = oldSwitchStatementBranch.getStatements()[0];
            PsiExpression rExpression = ExpressionUtils.getAssignmentTo((PsiElement)first, (PsiVariable)variable);
            if (rExpression == null) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)first, PsiThrowStatement.class);
                if (throwStatement == null) {
                    return null;
                }
                result = new SwitchStatementBranch(new PsiStatement[]{throwStatement});
            } else {
                result = new SwitchRuleExpressionResult(rExpression);
            }
            newBranches.add(new SwitchExpressionBranch(oldSwitchStatementBranch.isDefault(), oldSwitchStatementBranch.getCaseExpressions(), result, oldSwitchStatementBranch.getRelatedStatements()));
        }
        if (!isExhaustive) {
            newBranches.add(new SwitchExpressionBranch(true, Collections.emptyList(), new SwitchRuleExpressionResult(initializer), Collections.emptyList()));
        }
        return new SwitchExistingVariableReplacer((PsiVariable)variable, statement, expressionBeingSwitched, newBranches);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static SwitchReplacer inspectReplacementWithStatement(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<? extends OldSwitchStatementBranch> branches, boolean isExhaustive) {
        void var5_7;
        for (OldSwitchStatementBranch oldSwitchStatementBranch : branches) {
            if (EnhancedSwitchMigrationInspection.isConvertibleBranch(oldSwitchStatementBranch)) continue;
            return null;
        }
        ArrayList<SwitchExpressionBranch> switchRules = new ArrayList<SwitchExpressionBranch>();
        boolean bl = false;
        int branchesSize = branches.size();
        while (var5_7 < branchesSize) {
            OldSwitchStatementBranch branch = branches.get((int)var5_7);
            if (!branch.isFallthrough() || branch.getStatements().length != 0) {
                boolean allBranchRefsWillBeValid = ((StreamEx)StreamEx.of((Object[])branch.getStatements()).limit((long)var5_7)).flatMap(stmt -> StreamEx.ofTree((Object)stmt, el -> StreamEx.of((Object[])el.getChildren()))).select(PsiReferenceExpression.class).map(PsiReference::resolve).select(PsiLocalVariable.class).allMatch(variable -> EnhancedSwitchMigrationInspection.isInBranchOrOutside(statement, branch, variable));
                if (!allBranchRefsWillBeValid) {
                    return null;
                }
                if (!branch.isFallthrough() || branch.getStatements().length != 0) {
                    PsiStatement first;
                    PsiStatement[] statements = branch.getStatements();
                    if (!(statements.length != 1 || (first = statements[0]) instanceof PsiExpressionStatement || first instanceof PsiBlockStatement || first instanceof PsiThrowStatement)) {
                        return null;
                    }
                    switchRules.add(new SwitchExpressionBranch(branch.isDefault(), branch.getCaseExpressions(), new SwitchStatementBranch(statements), branch.getRelatedStatements()));
                }
            }
            ++var5_7;
        }
        return new SwitchStatementReplacer(statement, expressionBeingSwitched, switchRules);
    }

    private static boolean isInBranchOrOutside(@NotNull PsiStatement switchStmt, OldSwitchStatementBranch branch, PsiLocalVariable variable) {
        return !PsiTreeUtil.isAncestor((PsiElement)switchStmt, (PsiElement)variable, (boolean)false) || StreamEx.of((Object[])branch.getStatements()).anyMatch(stmt -> PsiTreeUtil.isAncestor((PsiElement)stmt, (PsiElement)variable, (boolean)false));
    }

    private static class OldSwitchStatementBranch {
        final boolean myIsFallthrough;
        @NotNull
        final PsiStatement[] myStatements;
        @NotNull
        final PsiSwitchLabelStatement myLabelStatement;
        @Nullable
        final PsiBreakStatement myBreakStatement;
        @Nullable
        OldSwitchStatementBranch myPreviousSwitchBranch = null;

        private OldSwitchStatementBranch(boolean isFallthrough, @NotNull PsiStatement[] statements, @NotNull PsiSwitchLabelStatement switchLabelStatement, @Nullable PsiBreakStatement breakStatement) {
            this.myIsFallthrough = isFallthrough;
            this.myStatements = statements;
            this.myLabelStatement = switchLabelStatement;
            this.myBreakStatement = breakStatement;
        }

        public boolean isDefault() {
            return this.myLabelStatement.isDefaultCase();
        }

        public boolean isFallthrough() {
            return this.myIsFallthrough;
        }

        public List<PsiExpression> getCaseExpressions() {
            List<OldSwitchStatementBranch> branches = this.getWithFallthroughBranches();
            Collections.reverse(branches);
            return StreamEx.of(branches).flatMap(branch -> {
                PsiExpressionList caseValues2 = branch.myLabelStatement.getCaseValues();
                if (caseValues2 == null) {
                    return StreamEx.empty();
                }
                return StreamEx.of((Object[])caseValues2.getExpressions());
            }).toList();
        }

        public List<PsiExpression> getCurrentBranchCaseExpressions() {
            PsiExpressionList caseValues2 = this.myLabelStatement.getCaseValues();
            if (caseValues2 == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(caseValues2.getExpressions());
        }

        public PsiStatement[] getStatements() {
            return this.myStatements;
        }

        public List<PsiStatement> getRelatedStatements() {
            StreamEx withoutBreak = StreamEx.of((Object[])this.myStatements).prepend((Object)this.myLabelStatement);
            return withoutBreak.prepend((Object)this.myBreakStatement).toList();
        }

        private List<OldSwitchStatementBranch> getWithFallthroughBranches() {
            ArrayList<OldSwitchStatementBranch> withPrevious = new ArrayList<OldSwitchStatementBranch>();
            OldSwitchStatementBranch current = this;
            do {
                withPrevious.add(current);
            } while ((current = current.myPreviousSwitchBranch) != null && current.myStatements.length == 0);
            return withPrevious;
        }

        public List<? extends PsiElement> getUsedElements() {
            return StreamEx.of(this.getWithFallthroughBranches()).flatMap(branch -> StreamEx.of(branch.getRelatedStatements())).toList();
        }
    }

    private static class SwitchExpressionBranch {
        final boolean myIsDefault;
        final List<PsiExpression> myCaseExpressions;
        @NotNull
        final List<? extends PsiElement> myUsedElements;
        private final SwitchRuleResult myRuleResult;

        private SwitchExpressionBranch(boolean isDefault, List<PsiExpression> caseExpressions, SwitchRuleResult ruleResult, @NotNull List<? extends PsiElement> usedElements) {
            this.myIsDefault = isDefault;
            this.myCaseExpressions = caseExpressions;
            this.myRuleResult = ruleResult;
            this.myUsedElements = usedElements;
        }

        String generate(CommentTracker ct) {
            StringBuilder sb = new StringBuilder();
            if (this.myIsDefault) {
                sb.append("default");
            } else {
                sb.append("case ");
                sb.append(StreamEx.of(this.myCaseExpressions).map(ct::text).joining((CharSequence)","));
            }
            sb.append("->");
            sb.append(this.myRuleResult.generate(ct));
            for (PsiElement psiElement : this.myUsedElements) {
                ct.grabComments(psiElement);
            }
            return sb.toString();
        }
    }

    private static class SwitchRuleExpressionResult
    implements SwitchRuleResult {
        private final PsiExpression myExpression;

        private SwitchRuleExpressionResult(PsiExpression expression2) {
            this.myExpression = expression2;
        }

        @Override
        public String generate(CommentTracker ct) {
            return ct.text((PsiElement)this.myExpression) + ";";
        }
    }

    private static class SwitchStatementBranch
    implements SwitchRuleResult {
        final PsiStatement[] myResultStatements;

        private SwitchStatementBranch(PsiStatement[] resultStatements) {
            this.myResultStatements = resultStatements;
        }

        @Override
        public String generate(CommentTracker ct) {
            if (this.myResultStatements.length == 1) {
                return ct.text((PsiElement)this.myResultStatements[0]);
            }
            return StreamEx.of((Object[])this.myResultStatements).map(ct::text).joining((CharSequence)"\n", (CharSequence)"{\n", (CharSequence)"}");
        }
    }

    private static class SwitchStatementReplacer
    implements SwitchReplacer {
        @NotNull
        final PsiStatement myStatement;
        @NotNull
        final PsiExpression myExpressionBeingSwitched;
        @NotNull
        final List<SwitchExpressionBranch> myExpressionBranches;

        private SwitchStatementReplacer(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, @NotNull List<SwitchExpressionBranch> ruleResults) {
            this.myStatement = statement;
            this.myExpressionBeingSwitched = expressionBeingSwitched;
            this.myExpressionBranches = ruleResults;
        }

        @Override
        public void replace(@NotNull PsiStatement switchStatement) {
            CommentTracker commentTracker = new CommentTracker();
            PsiSwitchBlock switchBlock = EnhancedSwitchMigrationInspection.generateEnhancedSwitch(switchStatement, this.myExpressionBeingSwitched, this.myExpressionBranches, commentTracker, false);
            if (switchBlock == null) {
                return;
            }
            commentTracker.replaceAndRestoreComments((PsiElement)switchStatement, (PsiElement)switchBlock);
        }

        @Override
        public ReplacementType getType() {
            return ReplacementType.Statement;
        }
    }

    private static class SwitchExistingVariableReplacer
    implements SwitchReplacer {
        @NotNull
        final PsiVariable myVariableToAssign;
        @NotNull
        final PsiStatement myStatement;
        @NotNull
        final PsiExpression myExpressionBeingSwitched;
        final List<SwitchExpressionBranch> myNewBranches;

        private SwitchExistingVariableReplacer(@NotNull PsiVariable variableToAssign, @NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, List<SwitchExpressionBranch> newBranches) {
            this.myVariableToAssign = variableToAssign;
            this.myStatement = statement;
            this.myExpressionBeingSwitched = expressionBeingSwitched;
            this.myNewBranches = newBranches;
        }

        @Override
        public void replace(@NotNull PsiStatement switchStatement) {
            List<PsiExpression> sideEffectExpressions;
            PsiStatement[] sideEffectStatements;
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)ObjectUtils.tryCast((Object)switchStatement.getParent(), PsiLabeledStatement.class);
            CommentTracker commentTracker = new CommentTracker();
            PsiSwitchBlock replacement = EnhancedSwitchMigrationInspection.generateEnhancedSwitch(switchStatement, this.myExpressionBeingSwitched, this.myNewBranches, commentTracker, true);
            PsiExpression initializer = this.myVariableToAssign.getInitializer();
            if (initializer != null && (sideEffectStatements = StatementExtractor.generateStatements(sideEffectExpressions = SideEffectChecker.extractSideEffectExpressions(initializer), initializer)).length > 0) {
                PsiStatement statement = (PsiStatement)ObjectUtils.tryCast((Object)this.myVariableToAssign.getParent(), PsiStatement.class);
                if (statement == null) {
                    return;
                }
                BlockUtils.addBefore(statement, sideEffectStatements);
            }
            this.myVariableToAssign.setInitializer((PsiExpression)((PsiSwitchExpression)replacement));
            commentTracker.delete((PsiElement)switchStatement);
            commentTracker.insertCommentsBefore((PsiElement)this.myVariableToAssign);
            if (labeledStatement != null) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)labeledStatement);
            }
        }

        @Override
        public ReplacementType getType() {
            return ReplacementType.Expression;
        }
    }

    private static class ReturningSwitchReplacer
    implements SwitchReplacer {
        @NotNull
        final PsiStatement myStatement;
        @NotNull
        final PsiExpression myExpressionBeingSwitched;
        final List<SwitchExpressionBranch> myNewBranches;
        @Nullable
        final PsiReturnStatement myReturnToDelete;

        private ReturningSwitchReplacer(@NotNull PsiStatement statement, @NotNull PsiExpression expressionBeingSwitched, List<SwitchExpressionBranch> newBranches, @Nullable PsiReturnStatement returnToDelete) {
            this.myStatement = statement;
            this.myExpressionBeingSwitched = expressionBeingSwitched;
            this.myNewBranches = newBranches;
            this.myReturnToDelete = returnToDelete;
        }

        @Override
        public void replace(@NotNull PsiStatement statement) {
            CommentTracker commentTracker = new CommentTracker();
            PsiSwitchBlock switchBlock = EnhancedSwitchMigrationInspection.generateEnhancedSwitch(statement, this.myExpressionBeingSwitched, this.myNewBranches, commentTracker, true);
            if (switchBlock == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement.getProject());
            PsiStatement returnStatement = factory.createStatementFromText("return " + switchBlock.getText() + ";", (PsiElement)switchBlock);
            commentTracker.replaceAndRestoreComments((PsiElement)statement, (PsiElement)returnStatement);
            if (this.myReturnToDelete != null) {
                CommentTracker ct = new CommentTracker();
                PsiExpression returnValue = this.myReturnToDelete.getReturnValue();
                if (returnValue != null) {
                    ct.markUnchanged(returnValue);
                }
                ct.deleteAndRestoreComments((PsiElement)this.myReturnToDelete);
            }
        }

        @Override
        public ReplacementType getType() {
            return ReplacementType.Expression;
        }
    }

    static class ReplaceWithSwitchExpressionFix
    implements LocalQuickFix {
        private final ReplacementType myReplacementType;

        ReplaceWithSwitchExpressionFix(ReplacementType replacementType) {
            this.myReplacementType = replacementType;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return this.myReplacementType.getFixName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiSwitchStatement statement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiSwitchStatement.class);
            if (statement == null) {
                return;
            }
            SwitchReplacer replacer = EnhancedSwitchMigrationInspection.findSwitchReplacer(statement);
            if (replacer == null) {
                return;
            }
            replacer.replace((PsiStatement)statement);
        }
    }

    private static interface SwitchRuleResult {
        public String generate(CommentTracker var1);
    }

    private static interface SwitchConversion {
        @Nullable
        public SwitchReplacer suggestReplacer(@NotNull PsiStatement var1, @NotNull PsiExpression var2, @NotNull List<? extends OldSwitchStatementBranch> var3, boolean var4);
    }

    public static interface SwitchReplacer {
        public void replace(@NotNull PsiStatement var1);

        public ReplacementType getType();
    }

    private static enum ReplacementType {
        Expression("inspection.replace.with.switch.expression.fix.name"),
        Statement("inspection.replace.with.enhanced.switch.statement.fix.name");

        private final String key;

        private ReplacementType(String key2) {
            this.key = key2;
        }

        String getFixName() {
            return InspectionsBundle.message((String)this.key, (Object[])new Object[0]);
        }
    }
}

