/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FunctionalExpressionCanBeFoldedInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
                PsiElement referenceNameElement2 = expression2.getReferenceNameElement();
                this.doCheckCall((PsiFunctionalExpression)expression2, () -> expression2.resolve(), qualifierExpression2, referenceNameElement2, "Method reference can be replaced with qualifier");
            }

            public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
                PsiElement body2 = lambdaExpression.getBody();
                PsiExpression asMethodReference = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body2, (PsiVariable[])lambdaExpression.getParameterList().getParameters(), lambdaExpression.getFunctionalInterfaceType(), null);
                if (asMethodReference instanceof PsiMethodCallExpression) {
                    PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)asMethodReference).getMethodExpression();
                    PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
                    this.doCheckCall((PsiFunctionalExpression)lambdaExpression, () -> ((PsiMethodCallExpression)asMethodReference).resolveMethod(), qualifierExpression2, (PsiElement)asMethodReference, "Lambda can be replaced with call qualifier");
                }
            }

            private void doCheckCall(PsiFunctionalExpression expression2, Supplier<? extends PsiElement> resolver, PsiExpression qualifierExpression2, PsiElement referenceNameElement2, String errorMessage) {
                PsiElement resolve;
                PsiType functionalInterfaceType;
                PsiMethod interfaceMethod;
                PsiType qualifierType;
                if (qualifierExpression2 != null && referenceNameElement2 != null && !(qualifierExpression2 instanceof PsiSuperExpression) && (qualifierType = qualifierExpression2.getType()) != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = LambdaUtil.getFunctionalInterfaceType((PsiElement)expression2, (boolean)true)))) != null && (resolve = resolver.get()) instanceof PsiMethod && (interfaceMethod == resolve || MethodSignatureUtil.isSuperMethod((PsiMethod)interfaceMethod, (PsiMethod)((PsiMethod)resolve))) && TypeConversionUtil.isAssignable((PsiType)functionalInterfaceType, (PsiType)qualifierType)) {
                    holder.registerProblem(referenceNameElement2, errorMessage, new LocalQuickFix[]{new ReplaceMethodRefWithQualifierFix()});
                }
            }
        };
    }

    private static class ReplaceMethodRefWithQualifierFix
    implements LocalQuickFix {
        private ReplaceMethodRefWithQualifierFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with qualifier";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression qualifierExpression2;
            PsiExpression expression2;
            PsiExpression qualifierExpression3;
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element != null ? element.getParent() : null;
            if (parent instanceof PsiMethodReferenceExpression && (qualifierExpression3 = ((PsiMethodReferenceExpression)parent).getQualifierExpression()) != null) {
                parent.replace((PsiElement)qualifierExpression3);
            }
            if (parent instanceof PsiReturnStatement || parent instanceof PsiExpressionStatement) {
                parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class);
            }
            if (parent instanceof PsiLambdaExpression && (expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)((PsiLambdaExpression)parent).getBody())) instanceof PsiMethodCallExpression && (qualifierExpression2 = ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression()) != null) {
                parent.replace((PsiElement)qualifierExpression2);
            }
        }
    }
}

