/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MoveFieldAssignmentToInitializerInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                TextRange range;
                if (!assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                    return;
                }
                if (assignment.getParent() instanceof PsiExpressionList || !ExpressionUtils.isVoidContext((PsiExpression)assignment)) {
                    return;
                }
                PsiField field = MoveFieldAssignmentToInitializerInspection.getAssignedField(assignment);
                if (field == null || field.hasInitializer()) {
                    return;
                }
                PsiClass psiClass = field.getContainingClass();
                if (psiClass == null || psiClass.isInterface()) {
                    return;
                }
                if (psiClass.getContainingFile() != holder.getFile()) {
                    return;
                }
                PsiModifierListOwner ctrOrInitializer = MoveFieldAssignmentToInitializerInspection.enclosingMethodOrClassInitializer(assignment, field);
                if (ctrOrInitializer == null) {
                    return;
                }
                if (ctrOrInitializer.hasModifierProperty("static") != field.hasModifierProperty("static")) {
                    return;
                }
                if (!MoveFieldAssignmentToInitializerInspection.isValidAsFieldInitializer(assignment.getRExpression(), ctrOrInitializer, field)) {
                    return;
                }
                if (!MoveFieldAssignmentToInitializerInspection.isInitializedWithSameExpression(field, assignment, new ArrayList())) {
                    return;
                }
                boolean shouldWarn = MoveFieldAssignmentToInitializerInspection.this.shouldWarn(ctrOrInitializer, field, assignment);
                if (!shouldWarn && !isOnTheFly) {
                    return;
                }
                if (shouldWarn && !InspectionProjectProfileManager.isInformationLevel((String)MoveFieldAssignmentToInitializerInspection.this.getShortName(), (PsiElement)assignment)) {
                    PsiExpression lValue = assignment.getLExpression();
                    range = new TextRange(0, lValue.getTextLength()).shiftRight(lValue.getStartOffsetInParent());
                } else {
                    range = new TextRange(0, assignment.getTextLength());
                }
                holder.registerProblem((PsiElement)assignment, CodeInsightBundle.message((String)"intention.move.field.assignment.to.declaration", (Object[])new Object[0]), shouldWarn ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION, range, new LocalQuickFix[]{new MoveFieldAssignmentToInitializerFix()});
            }
        };
    }

    boolean shouldWarn(PsiModifierListOwner ctrOrInitializer, PsiField field, PsiAssignmentExpression assignment) {
        if (!(ctrOrInitializer instanceof PsiClassInitializer)) {
            return false;
        }
        PsiExpressionStatement statement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)assignment.getParent(), PsiExpressionStatement.class);
        if (statement == null) {
            return false;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)ObjectUtils.tryCast((Object)statement.getParent(), PsiCodeBlock.class);
        if (codeBlock == null) {
            return false;
        }
        if (codeBlock.getParent() != ctrOrInitializer) {
            return false;
        }
        if (ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)ctrOrInitializer)).anyMatch(ref -> !PsiTreeUtil.isAncestor((PsiElement)assignment, (PsiElement)ref.getElement(), (boolean)true))) {
            return false;
        }
        if (((StreamEx)StreamEx.of((Object[])codeBlock.getStatements()).takeWhile(st -> statement != st)).allMatch(st -> ExpressionUtils.getAssignment((PsiElement)st) != null)) {
            return true;
        }
        PsiExpression value2 = assignment.getRExpression();
        return ExpressionUtils.isSafelyRecomputableExpression(value2) || ConstructionUtils.isEmptyCollectionInitializer(value2);
    }

    private static boolean isValidAsFieldInitializer(final PsiExpression initializer, final PsiModifierListOwner ctrOrInitializer, final PsiField field) {
        if (initializer == null) {
            return false;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{initializer}).isEmpty()) {
            return false;
        }
        final Ref result = new Ref((Object)Boolean.TRUE);
        final PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                PsiElement resolved = expression2.resolve();
                if (resolved == null) {
                    return;
                }
                if (resolved == field) {
                    result.set((Object)Boolean.FALSE);
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)ctrOrInitializer, (PsiElement)resolved, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)resolved, (boolean)false)) {
                    result.set((Object)Boolean.FALSE);
                    return;
                }
                if (resolved instanceof PsiMethod) {
                    resolved = PropertyUtil.getFieldOfGetter((PsiMethod)resolved);
                }
                if (resolved instanceof PsiField && ((PsiField)resolved).getContainingClass() == aClass) {
                    boolean initializedField;
                    boolean nonStaticRefersToStatic;
                    boolean bl = nonStaticRefersToStatic = !field.hasModifierProperty("static") && ((PsiField)resolved).hasModifierProperty("static");
                    if (nonStaticRefersToStatic) {
                        return;
                    }
                    boolean bl2 = initializedField = ((PsiField)resolved).getInitializer() != null;
                    if (initializedField) {
                        Object[] fields = aClass.getFields();
                        int indexSource = ArrayUtil.indexOf((Object[])fields, (Object)field);
                        int indexTarget = ArrayUtil.indexOf((Object[])fields, (Object)resolved);
                        if (indexTarget >= 0 && indexSource > indexTarget) {
                            return;
                        }
                    }
                    result.set((Object)Boolean.FALSE);
                }
            }
        });
        return (Boolean)result.get();
    }

    static PsiModifierListOwner enclosingMethodOrClassInitializer(PsiAssignmentExpression assignment, PsiField field) {
        PsiElement parent;
        PsiAssignmentExpression parentOwner = assignment;
        do {
            if ((parentOwner = PsiTreeUtil.getParentOfType((PsiElement)parentOwner, PsiModifierListOwner.class, (boolean)true, (Class[])new Class[]{PsiMember.class})) != null) continue;
            return null;
        } while ((parent = parentOwner.getParent()) != field.getContainingClass());
        return (PsiModifierListOwner)parentOwner;
    }

    private static boolean isInitializedWithSameExpression(final PsiField field, final PsiAssignmentExpression assignment, final Collection<? super PsiAssignmentExpression> initializingAssignments) {
        final PsiExpression expression2 = assignment.getRExpression();
        if (expression2 == null) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        final Ref result = new Ref((Object)Boolean.TRUE);
        final ArrayList totalUsages = new ArrayList();
        containingClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression reference) {
                if (!((Boolean)result.get()).booleanValue()) {
                    return;
                }
                super.visitReferenceExpression(reference);
                if (!PsiUtil.isOnAssignmentLeftHand((PsiExpression)reference)) {
                    return;
                }
                PsiElement resolved = reference.resolve();
                if (resolved != field) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiAssignmentExpression.class);
                if (assignmentExpression == null) {
                    return;
                }
                PsiExpression rValue = assignmentExpression.getRExpression();
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)assignmentExpression, PsiMember.class);
                if ((member instanceof PsiClassInitializer || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) && ExpressionUtils.isVoidContext((PsiExpression)assignmentExpression) && assignmentExpression.getOperationTokenType().equals(JavaTokenType.EQ)) {
                    if (rValue == null || !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(rValue, expression2)) {
                        result.set((Object)Boolean.FALSE);
                    }
                    initializingAssignments.add(assignmentExpression);
                }
                totalUsages.add(assignment);
            }
        });
        if (totalUsages.size() == 1 && initializingAssignments.isEmpty()) {
            initializingAssignments.addAll(totalUsages);
            return true;
        }
        return (Boolean)result.get();
    }

    private static PsiField getAssignedField(PsiAssignmentExpression assignment) {
        PsiExpression lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
        if (!(lExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)lExpression).resolve();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        return (PsiField)resolved;
    }

    private static class MoveFieldAssignmentToInitializerFix
    implements LocalQuickFix {
        private MoveFieldAssignmentToInitializerFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return CodeInsightBundle.message((String)"intention.move.field.assignment.to.declaration", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiCodeBlock body2;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiAssignmentExpression.class);
            if (assignment == null) {
                return;
            }
            PsiField field = MoveFieldAssignmentToInitializerInspection.getAssignedField(assignment);
            if (field == null) {
                return;
            }
            ArrayList assignments = new ArrayList();
            if (!MoveFieldAssignmentToInitializerInspection.isInitializedWithSameExpression(field, assignment, assignments)) {
                return;
            }
            PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)assignment.getParent());
            String comments = prev == null ? null : CommentTracker.commentsBetween(prev, (PsiElement)assignment);
            CommentTracker ct = new CommentTracker();
            PsiExpression initializer = Objects.requireNonNull(assignment.getRExpression());
            field.setInitializer(ct.markUnchanged(initializer));
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (comments != null) {
                PsiCodeBlock block = factory.createCodeBlockFromText("{" + comments + "}", (PsiElement)initializer);
                for (PsiElement child : block.getChildren()) {
                    if (!(child instanceof PsiComment) && !(child instanceof PsiWhiteSpace)) continue;
                    field.getParent().addBefore(child, (PsiElement)field);
                }
            }
            PsiModifierListOwner owner = MoveFieldAssignmentToInitializerInspection.enclosingMethodOrClassInitializer(assignment, field);
            for (PsiAssignmentExpression assignmentExpression : assignments) {
                PsiElement parent = assignmentExpression.getParent();
                if (parent instanceof PsiExpressionStatement) {
                    PsiElement grandParent = parent.getParent();
                    if (grandParent instanceof PsiIfStatement || grandParent instanceof PsiLoopStatement) {
                        ct.replace(parent, ";");
                    } else if (grandParent instanceof PsiSwitchLabeledRuleStatement) {
                        ct.replace(parent, "{}");
                    } else {
                        ct.delete(parent);
                    }
                } else if (parent instanceof PsiLambdaExpression) {
                    ct.replace((PsiElement)assignmentExpression, (PsiElement)factory.createCodeBlock());
                }
                ct.insertCommentsBefore((PsiElement)field);
                ct = new CommentTracker();
            }
            if (owner instanceof PsiClassInitializer && (body2 = ((PsiClassInitializer)owner).getBody()).isEmpty()) {
                if (Arrays.stream(body2.getChildren()).noneMatch(PsiComment.class::isInstance)) {
                    new CommentTracker().deleteAndRestoreComments((PsiElement)owner);
                }
            }
        }
    }
}

