/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.SingleSourceRootMoveDestination;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MoveToPackageFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.MoveToPackageFix");
    private final String myTargetPackage;

    public MoveToPackageFix(String targetPackage) {
        this.myTargetPackage = targetPackage;
    }

    @NotNull
    public String getName() {
        return QuickFixBundle.message("move.class.to.package.text", this.myTargetPackage);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("move.class.to.package.family", new Object[0]);
    }

    public boolean isAvailable(PsiFile myFile) {
        return myFile != null && myFile.isValid() && myFile.getManager().isInProject((PsiElement)myFile) && myFile instanceof PsiJavaFile && ((PsiJavaFile)myFile).getClasses().length != 0 && this.myTargetPackage != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        PsiFile myFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(myFile)) {
            return;
        }
        try {
            String error;
            PsiDirectory directory = null;
            try {
                directory = MoveClassesOrPackagesUtil.chooseDestinationPackage(project, this.myTargetPackage, myFile.getContainingDirectory());
                if (directory == null) {
                    return;
                }
                error = RefactoringMessageUtil.checkCanCreateFile(directory, myFile.getName());
            }
            catch (IncorrectOperationException e) {
                error = e.getLocalizedMessage();
            }
            if (error != null) {
                Messages.showMessageDialog((Project)project, (String)error, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            new MoveClassesOrPackagesProcessor(project, (PsiElement[])((PsiJavaFile)myFile).getClasses(), new SingleSourceRootMoveDestination(PackageWrapper.create((PsiPackage)JavaDirectoryService.getInstance().getPackage(directory)), directory), false, false, null).run();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

