/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalAssignedToNullInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean WARN_ON_COMPARISON = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report comparison of Optional with null", (InspectionProfileEntry)this, "WARN_ON_COMPARISON");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                this.checkNulls(expression2.getType(), expression2.getRExpression(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.assignment", (Object[])new Object[0]));
            }

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length > args.length) {
                    return;
                }
                boolean varArgCall = MethodCallUtils.isVarArgCall((PsiCall)call);
                if (!varArgCall && parameters2.length < args.length) {
                    return;
                }
                for (int i = 0; i < args.length; ++i) {
                    PsiParameter parameter2 = parameters2[Math.min(parameters2.length - 1, i)];
                    PsiType type2 = parameter2.getType();
                    if (varArgCall && i >= parameters2.length - 1 && type2 instanceof PsiEllipsisType) {
                        type2 = ((PsiEllipsisType)type2).getComponentType();
                    }
                    this.checkNulls(type2, args[i], InspectionsBundle.message((String)"inspection.null.value.for.optional.context.parameter", (Object[])new Object[0]));
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiElement body2 = lambda2.getBody();
                if (body2 instanceof PsiExpression) {
                    this.checkNulls(LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2), (PsiExpression)body2, InspectionsBundle.message((String)"inspection.null.value.for.optional.context.lambda", (Object[])new Object[0]));
                }
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                this.checkNulls(PsiTypesUtil.getMethodReturnType((PsiElement)statement), statement.getReturnValue(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.return", (Object[])new Object[0]));
            }

            public void visitVariable(PsiVariable variable) {
                this.checkNulls(variable.getType(), variable.getInitializer(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.declaration", (Object[])new Object[0]));
            }

            public void visitBinaryExpression(PsiBinaryExpression binOp) {
                if (!OptionalAssignedToNullInspection.this.WARN_ON_COMPARISON) {
                    return;
                }
                PsiExpression value2 = ExpressionUtils.getValueComparedWithNull(binOp);
                if (value2 != null && TypeUtils.isOptional(value2.getType()) && !this.hasSubsequentIsPresentCall(value2, (PsiExpression)binOp, JavaTokenType.EQEQ.equals(binOp.getOperationTokenType()))) {
                    holder.registerProblem((PsiElement)binOp, "Optional value is compared with null", new LocalQuickFix[]{new ReplaceWithIsPresentFix(), new SetInspectionOptionFix((LocalInspectionTool)OptionalAssignedToNullInspection.this, "WARN_ON_COMPARISON", "Do not warn when comparing Optional with null", false)});
                }
            }

            private boolean hasSubsequentIsPresentCall(@NotNull PsiExpression optionalExpression, @NotNull PsiExpression previousExpression, boolean negated) {
                IElementType expectedToken;
                PsiPolyadicExpression parent = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)previousExpression.getParent()), PsiPolyadicExpression.class);
                if (parent == null) {
                    return false;
                }
                IElementType iElementType = expectedToken = negated ? JavaTokenType.OROR : JavaTokenType.ANDAND;
                if (!parent.getOperationTokenType().equals(expectedToken)) {
                    return false;
                }
                PsiExpression nextExpression = ((StreamEx)((StreamEx)StreamEx.of((Object[])parent.getOperands()).dropWhile(op -> !PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)previousExpression, (boolean)false))).skip(1L)).findFirst().orElse(null);
                if ((nextExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextExpression)) == null) {
                    return false;
                }
                if (negated) {
                    if (!BoolUtils.isNegation(nextExpression)) {
                        return false;
                    }
                    nextExpression = BoolUtils.getNegated(nextExpression);
                }
                if (!(nextExpression instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)nextExpression;
                if (!"isPresent".equals(call.getMethodExpression().getReferenceName()) || !call.getArgumentList().isEmpty()) {
                    return false;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                return qualifier != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)optionalExpression);
            }

            private void checkNulls(PsiType type2, PsiExpression expression2, String declaration2) {
                if (expression2 != null && TypeUtils.isOptional(type2)) {
                    ExpressionUtils.nonStructuralChildren(expression2).filter(ExpressionUtils::isNullLiteral).forEach(nullLiteral -> this.register((PsiExpression)nullLiteral, (PsiClassType)type2, declaration2));
                }
            }

            private void register(PsiExpression expression2, PsiClassType type2, String contextName) {
                holder.registerProblem((PsiElement)expression2, InspectionsBundle.message((String)"inspection.null.value.for.optional.message", (Object[])new Object[]{contextName}), new LocalQuickFix[]{new ReplaceWithEmptyOptionalFix(type2)});
            }
        };
    }

    private static class ReplaceWithIsPresentFix
    implements LocalQuickFix {
        private ReplaceWithIsPresentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with 'isPresent()' call";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiBinaryExpression.class);
            if (binOp == null) {
                return;
            }
            PsiExpression value2 = ExpressionUtils.getValueComparedWithNull(binOp);
            if (value2 == null || !TypeUtils.isOptional(value2.getType())) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String negation = binOp.getOperationTokenType().equals(JavaTokenType.NE) ? "" : "!";
            ct.replaceAndRestoreComments((PsiElement)binOp, negation + ct.text(value2, 1) + ".isPresent()");
        }
    }

    private static class ReplaceWithEmptyOptionalFix
    implements LocalQuickFix {
        private final String myTypeName;
        private final String myTypeParameter;
        private final String myMethodName;

        ReplaceWithEmptyOptionalFix(PsiClassType type2) {
            this.myTypeName = type2.rawType().getCanonicalText();
            PsiType[] parameters2 = type2.getParameters();
            this.myTypeParameter = parameters2.length == 1 ? "<" + GenericsUtil.getVariableTypeByExpressionType((PsiType)parameters2[0]).getCanonicalText() + ">" : "";
            this.myMethodName = this.myTypeName.equals("com.google.common.base.Optional") ? "absent" : "empty";
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.null.value.for.optional.fix.name", (Object[])new Object[]{StringUtil.getShortName((String)this.myTypeName) + "." + this.myMethodName + "()"});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.null.value.for.optional.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            String emptyCall = this.myTypeName + "." + this.myTypeParameter + this.myMethodName + "()";
            PsiElement result = new CommentTracker().replaceAndRestoreComments(element, emptyCall);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        }
    }
}

