/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalIsPresentInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(OptionalIsPresentInspection.class);
    private static final OptionalIsPresentCase[] CASES = new OptionalIsPresentCase[]{new ReturnCase(), new AssignmentCase(), new ConsumerCase(), new TernaryCase()};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
                PsiReferenceExpression optionalRef;
                super.visitConditionalExpression(expression2);
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getCondition());
                if (condition2 == null) {
                    return;
                }
                boolean invert = false;
                PsiExpression strippedCondition = condition2;
                if (BoolUtils.isNegation(condition2)) {
                    strippedCondition = BoolUtils.getNegated(condition2);
                    invert = true;
                }
                if ((optionalRef = OptionalIsPresentInspection.extractOptionalFromIsPresentCheck(strippedCondition)) == null) {
                    return;
                }
                PsiExpression thenExpression2 = invert ? expression2.getElseExpression() : expression2.getThenExpression();
                PsiExpression elseExpression2 = invert ? expression2.getThenExpression() : expression2.getElseExpression();
                this.check(condition2, optionalRef, (PsiElement)thenExpression2, (PsiElement)elseExpression2);
            }

            public void visitIfStatement(@NotNull PsiIfStatement statement) {
                PsiReferenceExpression optionalRef;
                super.visitIfStatement(statement);
                PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getCondition());
                if (condition2 == null) {
                    return;
                }
                boolean invert = false;
                PsiExpression strippedCondition = condition2;
                if (BoolUtils.isNegation(condition2)) {
                    strippedCondition = BoolUtils.getNegated(condition2);
                    invert = true;
                }
                if ((optionalRef = OptionalIsPresentInspection.extractOptionalFromIsPresentCheck(strippedCondition)) == null) {
                    return;
                }
                PsiStatement thenStatement = OptionalIsPresentInspection.extractThenStatement(statement, invert);
                PsiStatement elseStatement = OptionalIsPresentInspection.extractElseStatement(statement, invert);
                this.check(condition2, optionalRef, (PsiElement)thenStatement, (PsiElement)elseStatement);
            }

            void check(@NotNull PsiExpression condition2, PsiReferenceExpression optionalRef, PsiElement thenElement, PsiElement elseElement) {
                for (OptionalIsPresentCase scenario : CASES) {
                    scenario.getProblemType(optionalRef, thenElement, elseElement).registerProblem(holder, condition2, scenario);
                }
            }
        };
    }

    private static boolean isRaw(@NotNull PsiVariable variable) {
        PsiType type2 = variable.getType();
        return type2 instanceof PsiClassType && ((PsiClassType)type2).isRaw();
    }

    @Nullable
    private static PsiStatement extractThenStatement(@NotNull PsiIfStatement ifStatement, boolean invert) {
        if (invert) {
            return OptionalIsPresentInspection.extractElseStatement(ifStatement, false);
        }
        return ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
    }

    @Nullable
    private static PsiStatement extractElseStatement(@NotNull PsiIfStatement ifStatement, boolean invert) {
        PsiElement nextElement;
        PsiStatement thenStatement;
        if (invert) {
            return OptionalIsPresentInspection.extractThenStatement(ifStatement, false);
        }
        PsiStatement statement = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (statement == null && (thenStatement = OptionalIsPresentInspection.extractThenStatement(ifStatement, false)) instanceof PsiReturnStatement && (nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement)) instanceof PsiStatement) {
            statement = ControlFlowUtils.stripBraces((PsiStatement)nextElement);
        }
        return statement;
    }

    @Nullable
    @Contract(value="null -> null")
    static PsiReferenceExpression extractOptionalFromIsPresentCheck(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        if (!call.getArgumentList().isEmpty()) {
            return null;
        }
        if (!"isPresent".equals(call.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.util.Optional".equals(containingClass.getQualifiedName())) {
            return null;
        }
        PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression().getQualifierExpression(), PsiReferenceExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiElement element = qualifier.resolve();
        if (!(element instanceof PsiVariable) || OptionalIsPresentInspection.isRaw((PsiVariable)element)) {
            return null;
        }
        return qualifier;
    }

    @Contract(value="null, _ -> false")
    static boolean isOptionalGetCall(PsiElement element, @NotNull PsiReferenceExpression optionalRef) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        if (!call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        return "get".equals(methodExpression.getReferenceName()) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)ExpressionUtils.getQualifierOrThis(methodExpression), (PsiElement)optionalRef);
    }

    @NotNull
    static ProblemType getTypeByLambdaCandidate(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement lambdaCandidate, @Nullable PsiExpression falseExpression) {
        if (lambdaCandidate == null) {
            return ProblemType.NONE;
        }
        if (lambdaCandidate instanceof PsiReferenceExpression && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lambdaCandidate, (PsiElement)optionalRef) && OptionalUtil.isOptionalEmptyCall(falseExpression)) {
            return ProblemType.WARNING;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda(lambdaCandidate, arg_0 -> ((PsiReferenceExpression)optionalRef).isReferenceTo(arg_0))) {
            return ProblemType.NONE;
        }
        Ref hasOptionalReference = new Ref((Object)Boolean.FALSE);
        boolean hasNoBadRefs = PsiTreeUtil.processElements((PsiElement)lambdaCandidate, e -> {
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)e, (PsiElement)optionalRef)) {
                return true;
            }
            hasOptionalReference.set((Object)Boolean.TRUE);
            return OptionalIsPresentInspection.isOptionalGetCall(e.getParent().getParent(), optionalRef);
        });
        if (!hasNoBadRefs) {
            return ProblemType.NONE;
        }
        if (!((Boolean)hasOptionalReference.get()).booleanValue() || !(lambdaCandidate instanceof PsiExpression)) {
            return ProblemType.INFO;
        }
        PsiExpression expression2 = (PsiExpression)lambdaCandidate;
        if (falseExpression != null) {
            if (!ExpressionUtils.isNullLiteral(falseExpression) && NullabilityUtil.getExpressionNullability(expression2, true) != Nullability.NOT_NULL) {
                return ProblemType.INFO;
            }
            PsiType falseType = falseExpression.getType();
            PsiType trueType = expression2.getType();
            if (falseType == null || trueType == null) {
                return ProblemType.NONE;
            }
            if (falseType instanceof PsiPrimitiveType && trueType instanceof PsiPrimitiveType) {
                if (falseType.equals(trueType) || JavaPsiMathUtil.getNumberFromLiteral(falseExpression) != null) {
                    return ProblemType.WARNING;
                }
                return ProblemType.NONE;
            }
            if (!trueType.isAssignableFrom(falseType)) {
                return ProblemType.NONE;
            }
        }
        return ProblemType.WARNING;
    }

    @NotNull
    static String generateOptionalLambda(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, PsiReferenceExpression optionalRef, PsiElement trueValue) {
        PsiType type2 = optionalRef.getType();
        String paramName = new VariableNameGenerator(trueValue, VariableKind.PARAMETER).byType(OptionalUtil.getOptionalElementType(type2)).byName("value").generate(true);
        if (trueValue instanceof PsiExpressionStatement) {
            trueValue = ((PsiExpressionStatement)trueValue).getExpression();
        }
        ct.markUnchanged(trueValue);
        PsiElement copy = trueValue.copy();
        for (PsiElement getCall : PsiTreeUtil.collectElements((PsiElement)copy, e -> OptionalIsPresentInspection.isOptionalGetCall(e, optionalRef))) {
            PsiElement result = getCall.replace((PsiElement)factory.createIdentifier(paramName));
            if (copy != getCall) continue;
            copy = result;
        }
        if (copy instanceof PsiStatement && !(copy instanceof PsiBlockStatement)) {
            return paramName + "->{" + copy.getText() + "}";
        }
        return paramName + "->" + copy.getText();
    }

    static String generateOptionalUnwrap(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, @NotNull PsiExpression trueValue, @NotNull PsiExpression falseValue, PsiType targetType) {
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)trueValue, (PsiElement)optionalRef) && OptionalUtil.isOptionalEmptyCall(falseValue)) {
            trueValue = factory.createExpressionFromText("java.util.Optional.of(" + optionalRef.getText() + ".get())", (PsiElement)trueValue);
        }
        if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseValue, (PsiElement)optionalRef)) {
            falseValue = factory.createExpressionFromText("java.util.Optional.empty()", (PsiElement)falseValue);
        }
        String lambdaText = OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalRef, (PsiElement)trueValue);
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)factory.createExpressionFromText(lambdaText, (PsiElement)trueValue);
        PsiExpression body2 = Objects.requireNonNull((PsiExpression)lambda2.getBody());
        return OptionalRefactoringUtil.generateOptionalUnwrap(optionalRef.getText(), (PsiVariable)lambda2.getParameterList().getParameters()[0], body2, ct.markUnchanged(falseValue), targetType, true);
    }

    static boolean isSimpleOrUnchecked(PsiExpression expression2) {
        return ExpressionUtils.isSafelyRecomputableExpression(expression2) || LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)expression2);
    }

    static class ConsumerCase
    implements OptionalIsPresentCase {
        ConsumerCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            if (falseElement != null && !(falseElement instanceof PsiEmptyStatement)) {
                return ProblemType.NONE;
            }
            if (!(trueElement instanceof PsiStatement)) {
                return ProblemType.NONE;
            }
            if (trueElement instanceof PsiExpressionStatement) {
                PsiExpression expression2 = ((PsiExpressionStatement)trueElement).getExpression();
                if (OptionalIsPresentInspection.isOptionalGetCall((PsiElement)expression2, optionalRef)) {
                    return ProblemType.NONE;
                }
                trueElement = expression2;
            }
            return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalRef, trueElement, null);
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, PsiElement trueElement, PsiElement falseElement) {
            return optionalRef.getText() + ".ifPresent(" + OptionalIsPresentInspection.generateOptionalLambda(factory, ct, optionalRef, trueElement) + ");";
        }
    }

    static class TernaryCase
    implements OptionalIsPresentCase {
        TernaryCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalVariable, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            if (!(trueElement instanceof PsiExpression) || !(falseElement instanceof PsiExpression)) {
                return ProblemType.NONE;
            }
            PsiExpression trueExpression = (PsiExpression)trueElement;
            PsiExpression falseExpression = (PsiExpression)falseElement;
            PsiType trueType = trueExpression.getType();
            PsiType falseType = falseExpression.getType();
            if (trueType == null || falseType == null || !trueType.isAssignableFrom(falseType) || !OptionalIsPresentInspection.isSimpleOrUnchecked(falseExpression)) {
                return ProblemType.NONE;
            }
            return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueExpression, falseExpression);
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            PsiExpression ternary = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)trueElement, PsiConditionalExpression.class);
            LOG.assertTrue(ternary != null);
            PsiExpression trueExpression = (PsiExpression)trueElement;
            PsiExpression falseExpression = (PsiExpression)falseElement;
            return OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueExpression, falseExpression, ternary.getType());
        }
    }

    static class AssignmentCase
    implements OptionalIsPresentCase {
        AssignmentCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalVariable, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueElement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseElement);
            if (trueAssignment == null || falseAssignment == null) {
                return ProblemType.NONE;
            }
            PsiExpression falseVal = falseAssignment.getRExpression();
            PsiExpression trueVal = trueAssignment.getRExpression();
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)trueAssignment.getLExpression(), (PsiElement)falseAssignment.getLExpression()) && OptionalIsPresentInspection.isSimpleOrUnchecked(falseVal)) {
                return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalVariable, (PsiElement)trueVal, falseVal);
            }
            return ProblemType.NONE;
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalRef, PsiElement trueElement, PsiElement falseElement) {
            PsiAssignmentExpression trueAssignment = ExpressionUtils.getAssignment(trueElement);
            PsiAssignmentExpression falseAssignment = ExpressionUtils.getAssignment(falseElement);
            LOG.assertTrue(trueAssignment != null);
            LOG.assertTrue(falseAssignment != null);
            PsiExpression lValue = trueAssignment.getLExpression();
            PsiExpression trueValue = trueAssignment.getRExpression();
            PsiExpression falseValue = falseAssignment.getRExpression();
            LOG.assertTrue(trueValue != null);
            LOG.assertTrue(falseValue != null);
            return lValue.getText() + " = " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalRef, trueValue, falseValue, lValue.getType()) + ";";
        }
    }

    static class ReturnCase
    implements OptionalIsPresentCase {
        ReturnCase() {
        }

        @Override
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression optionalRef, @Nullable PsiElement trueElement, @Nullable PsiElement falseElement) {
            if (!(trueElement instanceof PsiReturnStatement) || !(falseElement instanceof PsiReturnStatement)) {
                return ProblemType.NONE;
            }
            PsiExpression falseValue = ((PsiReturnStatement)falseElement).getReturnValue();
            PsiExpression trueValue = ((PsiReturnStatement)trueElement).getReturnValue();
            if (!OptionalIsPresentInspection.isSimpleOrUnchecked(falseValue)) {
                return ProblemType.NONE;
            }
            return OptionalIsPresentInspection.getTypeByLambdaCandidate(optionalRef, (PsiElement)trueValue, falseValue);
        }

        @Override
        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory factory, @NotNull CommentTracker ct, @NotNull PsiReferenceExpression optionalVariable, PsiElement trueElement, PsiElement falseElement) {
            PsiExpression trueValue = ((PsiReturnStatement)trueElement).getReturnValue();
            PsiExpression falseValue = ((PsiReturnStatement)falseElement).getReturnValue();
            LOG.assertTrue(trueValue != null);
            LOG.assertTrue(falseValue != null);
            return "return " + OptionalIsPresentInspection.generateOptionalUnwrap(factory, ct, optionalVariable, trueValue, falseValue, PsiTypesUtil.getMethodReturnType((PsiElement)trueElement)) + ";";
        }
    }

    static interface OptionalIsPresentCase {
        @NotNull
        public ProblemType getProblemType(@NotNull PsiReferenceExpression var1, @Nullable PsiElement var2, @Nullable PsiElement var3);

        @NotNull
        public String generateReplacement(@NotNull PsiElementFactory var1, @NotNull CommentTracker var2, @NotNull PsiReferenceExpression var3, PsiElement var4, PsiElement var5);
    }

    static class OptionalIsPresentFix
    implements LocalQuickFix {
        private final OptionalIsPresentCase myScenario;

        OptionalIsPresentFix(OptionalIsPresentCase scenario) {
            this.myScenario = scenario;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace Optional.isPresent() condition with functional style expression";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiStatement elseElement;
            PsiStatement thenElement;
            PsiReferenceExpression optionalRef;
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            PsiExpression condition2 = (PsiExpression)element;
            boolean invert = false;
            if (BoolUtils.isNegation(condition2)) {
                condition2 = BoolUtils.getNegated(condition2);
                invert = true;
            }
            if ((optionalRef = OptionalIsPresentInspection.extractOptionalFromIsPresentCheck(condition2)) == null) {
                return;
            }
            PsiElement cond = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class});
            if (cond instanceof PsiIfStatement) {
                thenElement = OptionalIsPresentInspection.extractThenStatement((PsiIfStatement)cond, invert);
                elseElement = OptionalIsPresentInspection.extractElseStatement((PsiIfStatement)cond, invert);
            } else if (cond instanceof PsiConditionalExpression) {
                thenElement = invert ? ((PsiConditionalExpression)cond).getElseExpression() : ((PsiConditionalExpression)cond).getThenExpression();
                elseElement = invert ? ((PsiConditionalExpression)cond).getThenExpression() : ((PsiConditionalExpression)cond).getElseExpression();
            } else {
                return;
            }
            if (this.myScenario.getProblemType(optionalRef, (PsiElement)thenElement, (PsiElement)elseElement) == ProblemType.NONE) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker ct = new CommentTracker();
            String replacementText = this.myScenario.generateReplacement(factory, ct, optionalRef, (PsiElement)thenElement, (PsiElement)elseElement);
            if (thenElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)thenElement, (boolean)true)) {
                ct.delete((PsiElement)thenElement);
            }
            if (elseElement != null && !PsiTreeUtil.isAncestor((PsiElement)cond, (PsiElement)elseElement, (boolean)true)) {
                ct.delete((PsiElement)elseElement);
            }
            PsiElement result = ct.replaceAndRestoreComments(cond, replacementText);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }
    }

    private static enum ProblemType {
        WARNING,
        INFO,
        NONE;


        void registerProblem(@NotNull ProblemsHolder holder, @NotNull PsiExpression condition2, OptionalIsPresentCase scenario) {
            if (this != NONE) {
                if (this == INFO && !holder.isOnTheFly()) {
                    return;
                }
                holder.registerProblem((PsiElement)condition2, "Can be replaced with single expression in functional style", this == INFO ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new OptionalIsPresentFix(scenario)});
            }
        }
    }
}

