/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PossibleHeapPollutionVarargsInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(PossibleHeapPollutionVarargsInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Possible heap pollution from parameterized vararg type";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "SafeVarargsDetector";
    }

    @NotNull
    public String getID() {
        return "unchecked";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new HeapPollutionVisitor(){

            @Override
            protected void registerProblem(PsiMethod method, PsiIdentifier nameIdentifier) {
                Object quickFix;
                if (GenericsHighlightUtil.isSafeVarargsNoOverridingCondition(method, PsiUtil.getLanguageLevel((PsiElement)method))) {
                    quickFix = new AnnotateAsSafeVarargsQuickFix();
                } else {
                    PsiClass containingClass = method.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    boolean canBeFinal = !method.hasModifierProperty("abstract") && !containingClass.isInterface() && OverridingMethodsSearch.search((PsiMethod)method).findFirst() == null;
                    quickFix = canBeFinal ? new MakeFinalAndAnnotateQuickFix() : null;
                }
                holder.registerProblem((PsiElement)nameIdentifier, "Possible heap pollution from parameterized vararg type #loc", new LocalQuickFix[]{quickFix});
            }
        };
    }

    public static abstract class HeapPollutionVisitor
    extends JavaElementVisitor {
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!PsiUtil.getLanguageLevel((PsiElement)method).isAtLeast(LanguageLevel.JDK_1_7)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.SafeVarargs", (int)0)) {
                return;
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiParameter psiParameter = parameters2[parameters2.length - 1];
            if (!psiParameter.isVarArgs()) {
                return;
            }
            PsiType type2 = psiParameter.getType();
            LOG.assertTrue(type2 instanceof PsiEllipsisType, (Object)("type: " + type2.getCanonicalText() + "; param: " + psiParameter));
            PsiType componentType = ((PsiEllipsisType)type2).getComponentType();
            if (JavaGenericsUtil.isReifiableType((PsiType)componentType)) {
                return;
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiParameter)) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression) || PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)element))) continue;
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerProblem(method, nameIdentifier);
            }
        }

        protected abstract void registerProblem(PsiMethod var1, PsiIdentifier var2);
    }

    private static class MakeFinalAndAnnotateQuickFix
    implements LocalQuickFix {
        private MakeFinalAndAnnotateQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Make final and annotate as @SafeVarargs";
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            return currentFile;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiIdentifier) {
                PsiMethod psiMethod = (PsiMethod)psiElement.getParent();
                WriteAction.run(() -> psiMethod.getModifierList().setModifierProperty("final", true));
                new AddAnnotationPsiFix("java.lang.SafeVarargs", (PsiModifierListOwner)psiMethod, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }
    }

    private static class AnnotateAsSafeVarargsQuickFix
    implements LocalQuickFix {
        private AnnotateAsSafeVarargsQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            return "Annotate as @SafeVarargs";
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod psiMethod;
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiIdentifier && (psiMethod = (PsiMethod)psiElement.getParent()) != null) {
                new AddAnnotationPsiFix("java.lang.SafeVarargs", (PsiModifierListOwner)psiMethod, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }
    }
}

