/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReadWriteStringCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher FILES_WRITE = CallMatcher.staticCall("java.nio.file.Files", "write").parameterTypes("java.nio.file.Path", "byte[]", "java.nio.file.OpenOption...");
    private static final CallMatcher FILES_READ_ALL_BYTES = CallMatcher.staticCall("java.nio.file.Files", "readAllBytes").parameterTypes("java.nio.file.Path");
    private static final CallMatcher STRING_GET_BYTES = CallMatcher.exactInstanceCall("java.lang.String", "getBytes").parameterTypes("java.nio.charset.Charset");
    private static final CallMatcher CHARSET_FOR_NAME = CallMatcher.staticCall("java.nio.charset.Charset", "forName").parameterTypes("java.lang.String");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        final LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)holder.getFile());
        if (level.isLessThan(LanguageLevel.JDK_11)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression[] args;
                PsiNewExpression newExpression;
                PsiExpressionList expressionList;
                if (FILES_WRITE.test(call)) {
                    PsiMethodCallExpression bytesExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ExpressionUtils.resolveExpression(call.getArgumentList().getExpressions()[1]), PsiMethodCallExpression.class);
                    if (STRING_GET_BYTES.test(bytesExpression) && bytesExpression.getMethodExpression().getQualifierExpression() != null) {
                        String message2 = "Can be replaced with 'Files.writeString()'";
                        ProblemHighlightType highlight = level.isAtLeast(LanguageLevel.JDK_12) || ReadWriteStringCanBeUsedInspection.isNonUtf8Charset(bytesExpression.getArgumentList().getExpressions()[0]) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                        holder.registerProblem((PsiElement)call, message2, highlight, new LocalQuickFix[]{new ReplaceWithWriteStringFix(highlight == ProblemHighlightType.INFORMATION)});
                    }
                } else if (FILES_READ_ALL_BYTES.test(call) && (expressionList = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiExpressionList.class)) != null && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiNewExpression.class)) != null && newExpression.getAnonymousClass() == null && ConstructionUtils.isReferenceTo(newExpression.getClassReference(), "java.lang.String") && (args = expressionList.getExpressions()).length == 2 && PsiTreeUtil.isAncestor((PsiElement)args[0], (PsiElement)call, (boolean)false) && TypeUtils.typeEquals("java.nio.charset.Charset", args[1].getType())) {
                    holder.registerProblem((PsiElement)newExpression, "Can be replaced with 'Files.readString()'", new LocalQuickFix[]{new ReplaceWithReadStringFix()});
                }
            }
        };
    }

    static boolean isUtf8Charset(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)expression2;
            if (!"UTF_8".equals(ref.getReferenceName())) {
                return false;
            }
            PsiField target = (PsiField)ObjectUtils.tryCast((Object)ref.resolve(), PsiField.class);
            return target != null && target.getContainingClass() != null && "java.nio.charset.StandardCharsets".equals(target.getContainingClass().getQualifiedName());
        }
        if (expression2 instanceof PsiMethodCallExpression && CHARSET_FOR_NAME.test((PsiMethodCallExpression)expression2)) {
            PsiExpression arg = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()[0];
            Object value2 = ExpressionUtils.computeConstantExpression(arg);
            return value2 instanceof String && ((String)value2).equalsIgnoreCase("utf-8");
        }
        return false;
    }

    static boolean isNonUtf8Charset(PsiExpression expression2) {
        for (int i = 0; i < 3; ++i) {
            PsiField target;
            block7: {
                block6: {
                    if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression) || (target = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiField.class)) == null) break block6;
                    if ("UTF_8".equals(target.getName())) {
                        return false;
                    }
                    if (target.getContainingClass() != null && "java.nio.charset.StandardCharsets".equals(target.getContainingClass().getQualifiedName())) {
                        return true;
                    }
                    if (target.hasModifierProperty("final")) break block7;
                }
                if (!(expression2 instanceof PsiMethodCallExpression) || !CHARSET_FOR_NAME.test((PsiMethodCallExpression)expression2)) break;
                PsiExpression arg = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()[0];
                Object value2 = ExpressionUtils.computeConstantExpression(arg);
                return value2 instanceof String && !((String)value2).equalsIgnoreCase("utf-8");
            }
            expression2 = target.getInitializer();
        }
        return false;
    }

    private static class ReplaceWithWriteStringFix
    implements LocalQuickFix {
        private final boolean myMayNotWork;

        private ReplaceWithWriteStringFix(boolean mayNotWork) {
            this.myMayNotWork = mayNotWork;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return this.myMayNotWork ? this.getFamilyName() + " (may not work before JDK 11.0.2)" : this.getFamilyName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Files.writeString()"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression writeCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (!FILES_WRITE.test(writeCall)) {
                return;
            }
            PsiExpressionList argumentList = writeCall.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length < 2) {
                return;
            }
            PsiExpression bytesArg = args[1];
            PsiMethodCallExpression bytesExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ExpressionUtils.resolveExpression(bytesArg), PsiMethodCallExpression.class);
            if (!STRING_GET_BYTES.test(bytesExpression)) {
                return;
            }
            PsiExpression stringExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)bytesExpression.getMethodExpression().getQualifierExpression());
            if (stringExpression == null) {
                return;
            }
            PsiExpression charsetExpression = bytesExpression.getArgumentList().getExpressions()[0];
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo(writeCall, "writeString");
            if (!ReadWriteStringCanBeUsedInspection.isUtf8Charset(charsetExpression)) {
                argumentList.addAfter((PsiElement)ct.markUnchanged(charsetExpression), (PsiElement)bytesArg);
            }
            PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable(PsiUtil.skipParenthesizedExprDown((PsiExpression)bytesArg));
            ct.replaceAndRestoreComments((PsiElement)bytesArg, (PsiElement)stringExpression);
            if (variable != null) {
                ct = new CommentTracker();
                ct.markUnchanged(stringExpression);
                ct.deleteAndRestoreComments((PsiElement)variable);
            }
        }
    }

    private static class ReplaceWithReadStringFix
    implements LocalQuickFix {
        private ReplaceWithReadStringFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Files.readString()"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiNewExpression.class);
            if (newExpression == null) {
                return;
            }
            PsiExpressionList newArgList = newExpression.getArgumentList();
            if (newArgList == null) {
                return;
            }
            PsiExpression[] newArgs = newArgList.getExpressions();
            if (newArgs.length != 2) {
                return;
            }
            PsiMethodCallExpression readCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)newArgs[0]), PsiMethodCallExpression.class);
            if (!FILES_READ_ALL_BYTES.test(readCall)) {
                return;
            }
            PsiExpression charsetExpression = newArgs[1];
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo(readCall, "readString");
            if (!ReadWriteStringCanBeUsedInspection.isUtf8Charset(charsetExpression)) {
                readCall.getArgumentList().add((PsiElement)ct.markUnchanged(charsetExpression));
            }
            ct.replaceAndRestoreComments((PsiElement)newExpression, (PsiElement)readCall);
        }
    }
}

