/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantBackticksAroundRawStringLiteralInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!HighlightUtil.Feature.RAW_LITERALS.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression2) {
                if (((PsiLiteralExpressionImpl)expression2).getLiteralElementType() == JavaTokenType.RAW_STRING_LITERAL) {
                    String text2 = expression2.getText();
                    final String rawString = ((PsiLiteralExpressionImpl)expression2).getRawString();
                    int reducedNumberOfBackTicks = PsiRawStringLiteralUtil.getReducedNumberOfBackticks((String)text2);
                    if (reducedNumberOfBackTicks > 0) {
                        final String newBackticksSequence = StringUtil.repeat((String)"`", (int)reducedNumberOfBackTicks);
                        int redundantTicksLength = (text2.length() - rawString.length()) / 2 - reducedNumberOfBackTicks;
                        holder.registerProblem((PsiElement)expression2, "Number of backticks may be reduced by " + redundantTicksLength, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new TextRange(0, redundantTicksLength), new LocalQuickFix[]{new LocalQuickFix(){

                            @Nls
                            @NotNull
                            public String getFamilyName() {
                                return "Reduce number of backticks";
                            }

                            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                PsiElement element = descriptor.getPsiElement();
                                PsiExpression newRawStringLiteral = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newBackticksSequence + rawString + newBackticksSequence, element);
                                element.replace((PsiElement)newRawStringLiteral);
                            }
                        }});
                    }
                }
            }
        };
    }
}

