/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantComparatorComparingInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher THEN_COMPARING_COMPARATOR = CallMatcher.instanceCall("java.util.Comparator", "thenComparing").parameterTypes("java.util.Comparator");
    private static final CallMatcher THEN_COMPARING_FUNCTION = CallMatcher.instanceCall("java.util.Comparator", "thenComparing").parameterTypes("java.util.function.Function");
    private static final CallMatcher COMPARATOR_REVERSED = CallMatcher.instanceCall("java.util.Comparator", "reversed").parameterCount(0);
    private static final CallMatcher REVERSE_ORDER_FOR_COMPARATOR = CallMatcher.staticCall("java.util.Collections", "reverseOrder").parameterTypes("java.util.Comparator");
    private static final CallMatcher REVERSE_ORDER_FOR_NATURAL = CallMatcher.staticCall("java.util.Comparator", "reverseOrder").parameterCount(0);
    private static final CallMatcher COMPARATOR_COMPARING_WITH_DOWNSTREAM = CallMatcher.staticCall("java.util.Comparator", "comparing").parameterTypes("java.util.function.Function", "java.util.Comparator");
    private static final CallMatcher MIN_MAX = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "min", "max").parameterTypes("java.util.Collection", "java.util.Comparator"), CallMatcher.instanceCall("java.util.stream.Stream", "min", "max").parameterTypes("java.util.Comparator"), CallMatcher.staticCall("java.util.stream.Collectors", "minBy", "maxBy").parameterTypes("java.util.Comparator"));
    private static final CallMapper<String> REPLACEMENTS = new CallMapper<String>().register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparing").parameterTypes("java.util.function.Function"), "thenComparing").register(COMPARATOR_COMPARING_WITH_DOWNSTREAM, "thenComparing").register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparingInt").parameterCount(1), "thenComparingInt").register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparingLong").parameterCount(1), "thenComparingLong").register((CallMatcher)CallMatcher.staticCall("java.util.Comparator", "comparingDouble").parameterCount(1), "thenComparingDouble");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression arg;
                if (THEN_COMPARING_COMPARATOR.test(call)) {
                    this.checkThenComparing(call);
                }
                if (MIN_MAX.test(call) && RedundantComparatorComparingInspection.getPlainComparatorExpressionFromReversed(arg = (PsiExpression)ArrayUtil.getLastElement((Object[])call.getArgumentList().getExpressions()), new CommentTracker()) != null) {
                    PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                    String maxOrMin = nameElement.getText();
                    String replacement = RedundantComparatorComparingInspection.getMaxMinReplacement(maxOrMin);
                    holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.simplifiable.comparator.reversed.message", (Object[])new Object[]{maxOrMin, replacement}), new LocalQuickFix[]{new ReplaceMaxMinFix(replacement)});
                }
            }

            private void checkThenComparing(@NotNull PsiMethodCallExpression call) {
                PsiMethodCallExpression comparingCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
                String targetMethod = (String)REPLACEMENTS.mapFirst(comparingCall);
                if (targetMethod == null) {
                    return;
                }
                PsiExpressionList comparingArgs = comparingCall.getArgumentList();
                if (targetMethod.equals("thenComparing") && comparingArgs.getExpressionCount() == 1) {
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)call.copy();
                    copy.getArgumentList().replace(comparingArgs.copy());
                    if (!THEN_COMPARING_FUNCTION.matches((PsiExpression)copy)) {
                        return;
                    }
                }
                String name = comparingCall.getMethodExpression().getReferenceName();
                holder.registerProblem((PsiElement)comparingCall.getMethodExpression(), InspectionsBundle.message((String)"inspection.simplifiable.comparator.comparing.message", (Object[])new Object[]{name}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteComparingCallFix(name, targetMethod)});
            }
        };
    }

    @NotNull
    private static String getMaxMinReplacement(@NotNull String maxOrMin) {
        return (maxOrMin.startsWith("max") ? "min" : "max") + maxOrMin.substring(3);
    }

    @Nullable
    static String getPlainComparatorExpressionFromReversed(PsiExpression expression2, CommentTracker ct) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        if (COMPARATOR_REVERSED.test(call)) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            return qualifier == null ? null : ct.text((PsiElement)qualifier);
        }
        if (REVERSE_ORDER_FOR_COMPARATOR.test(call)) {
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            PsiType type2 = call.getType();
            if (type2 != null && type2.equals(arg.getType())) {
                return ct.text((PsiElement)arg);
            }
        }
        if (REVERSE_ORDER_FOR_NATURAL.test(call)) {
            PsiReferenceParameterList parameterList = call.getMethodExpression().getParameterList();
            return "java.util.Comparator." + (parameterList == null ? "" : ct.text((PsiElement)parameterList)) + "naturalOrder()";
        }
        if (COMPARATOR_COMPARING_WITH_DOWNSTREAM.test(call) && REVERSE_ORDER_FOR_NATURAL.matches(call.getArgumentList().getExpressions()[1])) {
            return ct.text((PsiElement)call.getMethodExpression()) + "(" + ct.text((PsiElement)call.getArgumentList().getExpressions()[0]) + ")";
        }
        return null;
    }

    private static class ReplaceMaxMinFix
    implements LocalQuickFix {
        private final String myReplacement;

        ReplaceMaxMinFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.simplifiable.comparator.fix.reversed.name", (Object[])new Object[]{this.myReplacement});
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.simplifiable.comparator.fix.reversed.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression comparator = (PsiExpression)ArrayUtil.getLastElement((Object[])call.getArgumentList().getExpressions());
            if (comparator == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String reversed = RedundantComparatorComparingInspection.getPlainComparatorExpressionFromReversed(comparator, ct);
            if (reversed == null) {
                return;
            }
            ct.replaceAndRestoreComments((PsiElement)comparator, reversed);
            ExpressionUtils.bindCallTo(call, this.myReplacement);
        }
    }

    static class DeleteComparingCallFix
    implements LocalQuickFix {
        private final String mySourceMethod;
        private final String myTargetMethod;

        DeleteComparingCallFix(String sourceMethod, String targetMethod) {
            this.mySourceMethod = sourceMethod;
            this.myTargetMethod = targetMethod;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myTargetMethod.equals("thenComparing") ? InspectionsBundle.message((String)"inspection.simplifiable.comparator.fix.remove.name", (Object[])new Object[]{this.mySourceMethod}) : InspectionsBundle.message((String)"inspection.simplifiable.comparator.fix.replace.name", (Object[])new Object[]{this.mySourceMethod, this.myTargetMethod});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.simplifiable.comparator.fix.comparing.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression comparingCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (comparingCall == null) {
                return;
            }
            PsiMethodCallExpression thenComparingCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)comparingCall, PsiMethodCallExpression.class);
            if (thenComparingCall == null) {
                return;
            }
            ExpressionUtils.bindCallTo(thenComparingCall, this.myTargetMethod);
            CommentTracker ct = new CommentTracker();
            thenComparingCall.getArgumentList().replace((PsiElement)ct.markUnchanged(comparingCall.getArgumentList()));
        }
    }
}

