/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantExplicitVariableTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.getLanguageLevel((PsiElement)holder.getFile()).isAtLeast(LanguageLevel.JDK_10)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLocalVariable(PsiLocalVariable variable) {
                PsiTypeElement typeElement = variable.getTypeElement();
                if (!typeElement.isInferredType()) {
                    PsiElement parent = variable.getParent();
                    if (parent instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent).getDeclaredElements().length > 1) {
                        return;
                    }
                    this.doCheck((PsiVariable)variable, (PsiVariable)((PsiLocalVariable)variable.copy()), typeElement);
                }
            }

            public void visitForeachStatement(PsiForeachStatement statement) {
                super.visitForeachStatement(statement);
                PsiParameter parameter2 = statement.getIterationParameter();
                PsiTypeElement typeElement = parameter2.getTypeElement();
                if (typeElement != null && !typeElement.isInferredType()) {
                    PsiForeachStatement copy = (PsiForeachStatement)statement.copy();
                    this.doCheck((PsiVariable)parameter2, (PsiVariable)copy.getIterationParameter(), typeElement);
                }
            }

            private void doCheck(PsiVariable variable, PsiVariable copyVariable, PsiTypeElement element2Highlight) {
                PsiTypeElement typeElementCopy = copyVariable.getTypeElement();
                if (typeElementCopy != null) {
                    IntroduceVariableBase.expandDiamondsAndReplaceExplicitTypeWithVar(typeElementCopy, (PsiElement)variable);
                    if (variable.getType().equals(copyVariable.getType())) {
                        holder.registerProblem((PsiElement)element2Highlight, "Explicit type of local variable can be omitted", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithVarFix()});
                    }
                }
            }
        };
    }

    private static class ReplaceWithVarFix
    implements LocalQuickFix {
        private ReplaceWithVarFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace explicit type with 'var'";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiTypeElement) {
                CodeStyleManager.getInstance((Project)project).reformat(IntroduceVariableBase.expandDiamondsAndReplaceExplicitTypeWithVar((PsiTypeElement)element, element));
            }
        }
    }
}

