/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAnnotationQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiAnnotation> myAnnotation;
    private final SmartPsiElementPointer<PsiModifierListOwner> myListOwner;

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner) {
        Project project = annotation.getProject();
        SmartPointerManager pm = SmartPointerManager.getInstance((Project)project);
        this.myAnnotation = pm.createSmartPsiElementPointer((PsiElement)annotation);
        this.myListOwner = listOwner == null ? null : pm.createSmartPsiElementPointer((PsiElement)listOwner);
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"remove.annotation", (Object[])new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiAnnotation annotation = (PsiAnnotation)this.myAnnotation.getElement();
        if (annotation == null) {
            return;
        }
        if (annotation.isPhysical()) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)annotation)) {
                return;
            }
            WriteAction.run(() -> annotation.delete());
        } else {
            PsiModifierListOwner listOwner = (PsiModifierListOwner)this.myListOwner.getElement();
            String qualifiedName = annotation.getQualifiedName();
            if (listOwner != null && qualifiedName != null) {
                ExternalAnnotationsManager.getInstance((Project)project).deannotate(listOwner, qualifiedName);
            }
        }
    }
}

