/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class RemoveAssignmentFix
extends RemoveInitializerFix {
    @Override
    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.unused.assignment.remove.assignment.quickfix", (Object[])new Object[0]);
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement gParent;
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element instanceof PsiReferenceExpression ? element.getParent() : element;
        if (!(parent instanceof PsiAssignmentExpression)) {
            return;
        }
        IElementType operationSign = ((PsiAssignmentExpression)parent).getOperationTokenType();
        PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
        if (JavaTokenType.EQ != operationSign && rExpression != null) {
            rExpression = DeclarationJoinLinesHandler.getInitializerExpression(((PsiAssignmentExpression)parent).getLExpression(), (PsiAssignmentExpression)parent);
        }
        if (((gParent = parent.getParent()) instanceof PsiExpression || gParent instanceof PsiExpressionList || gParent instanceof PsiReturnStatement) && rExpression != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(gParent.getContainingFile())) {
                return;
            }
            PsiExpression finalRExpr = rExpression;
            WriteAction.run(() -> {
                if (gParent instanceof PsiParenthesizedExpression) {
                    gParent.replace((PsiElement)finalRExpr);
                } else {
                    parent.replace((PsiElement)finalRExpr);
                }
            });
            return;
        }
        PsiElement resolve = null;
        if (element instanceof PsiReferenceExpression) {
            resolve = ((PsiReferenceExpression)element).resolve();
        } else {
            PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiAssignmentExpression)parent).getLExpression());
            if (lExpr instanceof PsiReferenceExpression) {
                resolve = ((PsiReferenceExpression)lExpr).resolve();
            }
        }
        if (!(resolve instanceof PsiVariable)) {
            return;
        }
        RemoveAssignmentFix.sideEffectAwareRemove(project, rExpression, parent, (PsiVariable)resolve);
    }
}

