/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInefficientStreamCountInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STREAM_COUNT = CallMatcher.instanceCall("java.util.stream.Stream", "count").parameterCount(0);
    private static final CallMatcher COLLECTION_STREAM = CallMatcher.instanceCall("java.util.Collection", "stream").parameterCount(0);
    private static final CallMatcher STREAM_FLAT_MAP = CallMatcher.instanceCall("java.util.stream.Stream", "flatMap").parameterTypes("java.util.function.Function");
    private static final CallMatcher STREAM_FILTER = CallMatcher.instanceCall("java.util.stream.BaseStream", "filter").parameterCount(1);
    private static final CallMapper<CountFix> FIX_MAPPER = new CallMapper<Function<PsiMethodCallExpression, CountFix>>().register(COLLECTION_STREAM, call -> new CountFix(SimplificationMode.COLLECTION_SIZE)).register(STREAM_FLAT_MAP, call -> ReplaceInefficientStreamCountInspection.doesFlatMapCallCollectionStream(call) ? new CountFix(SimplificationMode.SUM) : null).register(STREAM_FILTER, call -> ReplaceInefficientStreamCountInspection.extractComparisonWithZero(call) != null ? new CountFix(SimplificationMode.ANY_MATCH) : null).register(STREAM_FILTER, call -> ReplaceInefficientStreamCountInspection.extractComparisonWithZeroEq(call) != null ? new CountFix(SimplificationMode.NONE_MATCH) : null);
    private static final Logger LOG = Logger.getInstance(ReplaceInefficientStreamCountInspection.class);
    private static final String SIZE_METHOD = "size";
    private static final String STREAM_METHOD = "stream";

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                if (STREAM_COUNT.test(methodCall)) {
                    PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(methodCall);
                    CountFix fix2 = (CountFix)FIX_MAPPER.mapFirst(qualifierCall);
                    if (fix2 != null) {
                        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                        LOG.assertTrue(nameElement != null);
                        holder.registerProblem((PsiElement)methodCall, nameElement.getTextRange().shiftRight(-methodCall.getTextOffset()), fix2.getMessage(), new LocalQuickFix[]{fix2});
                    }
                }
            }
        };
    }

    @Nullable
    private static PsiBinaryExpression extractComparisonWithZero(PsiMethodCallExpression filterCall) {
        PsiBinaryExpression binary = ReplaceInefficientStreamCountInspection.extractBinary(filterCall);
        if (binary == null) {
            return null;
        }
        IElementType tokenType = binary.getOperationTokenType();
        if (ExpressionUtils.isZero(binary.getLOperand()) && (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.NE) || ExpressionUtils.isZero(binary.getROperand()) && (tokenType == JavaTokenType.GT || tokenType == JavaTokenType.NE)) {
            return binary;
        }
        return null;
    }

    @Nullable
    private static PsiBinaryExpression extractComparisonWithZeroEq(PsiMethodCallExpression filterCall) {
        PsiBinaryExpression binary = ReplaceInefficientStreamCountInspection.extractBinary(filterCall);
        if (binary == null) {
            return null;
        }
        IElementType tokenType = binary.getOperationTokenType();
        if (ExpressionUtils.isZero(binary.getLOperand()) && tokenType == JavaTokenType.EQEQ || ExpressionUtils.isZero(binary.getROperand()) && tokenType == JavaTokenType.EQEQ) {
            return binary;
        }
        return null;
    }

    @Nullable
    private static PsiBinaryExpression extractBinary(PsiMethodCallExpression filterCall) {
        PsiMethodCallExpression countCall = ExpressionUtils.getCallForQualifier((PsiExpression)filterCall);
        if (countCall == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)countCall.getParent());
        if (parent == null) {
            return null;
        }
        return (PsiBinaryExpression)ObjectUtils.tryCast((Object)parent, PsiBinaryExpression.class);
    }

    static boolean doesFlatMapCallCollectionStream(PsiMethodCallExpression flatMapCall) {
        PsiExpression function = flatMapCall.getArgumentList().getExpressions()[0];
        if (function instanceof PsiMethodReferenceExpression) {
            PsiClass containingClass;
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)function;
            if (!STREAM_METHOD.equals(methodRef.getReferenceName())) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            if (method != null && STREAM_METHOD.equals(method.getName()) && method.getParameterList().isEmpty() && (containingClass = method.getContainingClass()) != null && "java.util.Collection".equals(containingClass.getQualifiedName())) {
                return true;
            }
        } else if (function instanceof PsiLambdaExpression) {
            PsiExpression expression2 = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)function);
            return expression2 instanceof PsiMethodCallExpression && COLLECTION_STREAM.test((PsiMethodCallExpression)expression2);
        }
        return false;
    }

    @Nullable
    private static PsiExpression extractLambdaReturnExpression(PsiLambdaExpression lambda2) {
        PsiStatement[] statements;
        PsiElement lambdaBody = lambda2.getBody();
        PsiExpression expression2 = null;
        if (lambdaBody instanceof PsiExpression) {
            expression2 = (PsiExpression)lambdaBody;
        } else if (lambdaBody instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambdaBody).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            expression2 = ((PsiReturnStatement)statements[0]).getReturnValue();
        }
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
    }

    private static class CountFix
    implements LocalQuickFix {
        private final SimplificationMode mySimplificationMode;

        CountFix(SimplificationMode simplificationMode) {
            this.mySimplificationMode = simplificationMode;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.mySimplificationMode.getName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace inefficient Stream.count()";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression countCall = (PsiMethodCallExpression)element;
            PsiElement countName = countCall.getMethodExpression().getReferenceNameElement();
            if (countName == null) {
                return;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(countCall);
            if (qualifierCall == null) {
                return;
            }
            switch (this.mySimplificationMode) {
                case SUM: {
                    CountFix.replaceFlatMap(countName, qualifierCall);
                    break;
                }
                case COLLECTION_SIZE: {
                    CountFix.replaceSimpleCount(countCall, qualifierCall);
                    break;
                }
                case ANY_MATCH: {
                    CountFix.replaceFilterCountComparison(qualifierCall, true);
                    break;
                }
                case NONE_MATCH: {
                    CountFix.replaceFilterCountComparison(qualifierCall, false);
                }
            }
        }

        private static void replaceFilterCountComparison(PsiMethodCallExpression filterCall, boolean isAnyMatch) {
            PsiBinaryExpression comparison;
            if (!STREAM_FILTER.test(filterCall)) {
                return;
            }
            PsiBinaryExpression psiBinaryExpression = comparison = isAnyMatch ? ReplaceInefficientStreamCountInspection.extractComparisonWithZero(filterCall) : ReplaceInefficientStreamCountInspection.extractComparisonWithZeroEq(filterCall);
            if (comparison == null) {
                return;
            }
            String filterText = filterCall.getArgumentList().getExpressions()[0].getText();
            PsiExpression filterQualifier = filterCall.getMethodExpression().getQualifierExpression();
            if (filterQualifier == null) {
                return;
            }
            String base = filterQualifier.getText();
            CommentTracker ct = new CommentTracker();
            ct.markUnchanged(filterQualifier);
            ct.replaceAndRestoreComments((PsiElement)comparison, base + "." + (isAnyMatch ? "anyMatch" : "noneMatch") + "(" + filterText + ")");
        }

        private static void replaceSimpleCount(PsiMethodCallExpression countCall, PsiMethodCallExpression qualifierCall) {
            String replacementText;
            PsiElement replacement;
            PsiTypeElement castElement;
            if (!COLLECTION_STREAM.test(qualifierCall)) {
                return;
            }
            PsiReferenceExpression methodExpression = qualifierCall.getMethodExpression();
            ExpressionUtils.bindCallTo(qualifierCall, ReplaceInefficientStreamCountInspection.SIZE_METHOD);
            boolean addCast = true;
            PsiMethodCallExpression toReplace = countCall;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)countCall.getParent());
            if (parent instanceof PsiExpressionStatement) {
                addCast = false;
            } else if (parent instanceof PsiTypeCastExpression && (castElement = ((PsiTypeCastExpression)parent).getCastType()) != null && castElement.getType() instanceof PsiPrimitiveType) {
                addCast = false;
                if (PsiType.INT.equals((Object)castElement.getType())) {
                    toReplace = parent;
                }
            }
            CommentTracker ct = new CommentTracker();
            PsiReferenceParameterList parameterList = methodExpression.getParameterList();
            if (parameterList != null) {
                ct.delete((PsiElement)parameterList);
            }
            if ((replacement = ct.replaceAndRestoreComments((PsiElement)toReplace, replacementText = (addCast ? "(long) " : "") + ct.text((PsiElement)methodExpression) + "()")) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)replacement))) {
                RemoveRedundantCastUtil.removeCast((PsiTypeCastExpression)replacement);
            }
        }

        private static void replaceFlatMap(PsiElement countName, PsiMethodCallExpression qualifierCall) {
            PsiExpression expression2;
            if (!STREAM_FLAT_MAP.test(qualifierCall)) {
                return;
            }
            PsiElement flatMapName = qualifierCall.getMethodExpression().getReferenceNameElement();
            if (flatMapName == null) {
                return;
            }
            PsiExpression parameter2 = qualifierCall.getArgumentList().getExpressions()[0];
            PsiElement streamCallName = null;
            if (parameter2 instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)parameter2;
                streamCallName = methodRef.getReferenceNameElement();
            } else if (parameter2 instanceof PsiLambdaExpression && (expression2 = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)parameter2)) instanceof PsiMethodCallExpression) {
                streamCallName = ((PsiMethodCallExpression)expression2).getMethodExpression().getReferenceNameElement();
            }
            if (streamCallName == null || !streamCallName.getText().equals(ReplaceInefficientStreamCountInspection.STREAM_METHOD)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)qualifierCall.getProject());
            streamCallName.replace((PsiElement)factory.createIdentifier(ReplaceInefficientStreamCountInspection.SIZE_METHOD));
            flatMapName.replace((PsiElement)factory.createIdentifier("mapToLong"));
            countName.replace((PsiElement)factory.createIdentifier("sum"));
            PsiReferenceParameterList parameterList = qualifierCall.getMethodExpression().getParameterList();
            if (parameterList != null) {
                parameterList.delete();
            }
        }

        public String getMessage() {
            return this.mySimplificationMode.getMessage();
        }
    }

    private static enum SimplificationMode {
        SUM("Replace Stream.flatMap().count() with Stream.mapToLong().sum()", "Stream.flatMap().count() can be replaced with Stream.mapToLong().sum()"),
        COLLECTION_SIZE("Replace Collection.stream().count() with Collection.size()", "Collection.stream().count() can be replaced with Collection.size()"),
        ANY_MATCH("Replace Stream().filter().count() > 0 with stream.anyMatch()", "Stream().filter().count() > 0 can be replaced with stream.anyMatch()"),
        NONE_MATCH("Replace Stream().filter().count() == 0 with stream.noneMatch()", "Stream().filter().count() == 0 can be replaced with stream.noneMatch()");

        private final String myName;
        private final String myMessage;

        public String getName() {
            return this.myName;
        }

        private SimplificationMode(String name, String message2) {
            this.myName = name;
            this.myMessage = message2;
        }

        public String getMessage() {
            return this.myMessage;
        }
    }
}

