/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTrivialLambdaFix
implements LocalQuickFix {
    private final String myValue;

    public ReplaceWithTrivialLambdaFix(Object value2) {
        this.myValue = String.valueOf(value2);
    }

    @Nls
    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"inspection.replace.with.trivial.lambda.fix.name", (Object[])new Object[]{this.myValue});
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.replace.with.trivial.lambda.fix.family.name", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodReferenceExpression.class);
        if (methodRef == null) {
            return;
        }
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodRef, true, true);
        if (lambdaExpression == null) {
            return;
        }
        PsiElement body2 = lambdaExpression.getBody();
        if (body2 == null) {
            return;
        }
        body2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myValue, (PsiElement)lambdaExpression));
    }
}

