/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AnnotatedElementInspectionBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ScheduledForRemovalInspection
extends AnnotatedElementInspectionBase {
    private static final String ANNOTATION_NAME = ApiStatus.ScheduledForRemoval.class.getCanonicalName();

    @Override
    @NotNull
    protected List<String> getAnnotations() {
        return Collections.singletonList(ANNOTATION_NAME);
    }

    @Override
    protected void createProblem(@NotNull PsiReference reference, @NotNull PsiModifierListOwner annotatedTarget, @NotNull List<PsiAnnotation> annotations2, @NotNull ProblemsHolder holder) {
        PsiAnnotation scheduledForRemoval = (PsiAnnotation)ContainerUtil.find(annotations2, psiAnnotation -> psiAnnotation.hasQualifiedName(ANNOTATION_NAME));
        if (scheduledForRemoval != null) {
            String inVersion = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)scheduledForRemoval, (String)"inVersion");
            String targetText = ScheduledForRemovalInspection.getPresentableText((PsiElement)annotatedTarget);
            String message2 = inVersion == null || inVersion.isEmpty() ? JvmAnalysisBundle.message("jvm.inspections.scheduled.for.removal.description.no.version", targetText) : JvmAnalysisBundle.message("jvm.inspections.scheduled.for.removal.description.with.version", targetText, inVersion);
            holder.registerProblem(reference, message2, ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL);
        }
    }
}

