/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ReflectionUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SetInspectionOptionFix
implements LocalQuickFix,
LowPriorityAction,
Iconable {
    private final String myID;
    private final String myProperty;
    private final String myMessage;
    private final boolean myValue;

    public SetInspectionOptionFix(LocalInspectionTool inspection, String property, String message2, boolean value2) {
        this.myID = inspection.getID();
        this.myProperty = property;
        this.myMessage = message2;
        this.myValue = value2;
    }

    @Nls
    @NotNull
    public String getName() {
        return this.myMessage;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Set inspection option";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        final VirtualFile vFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
        this.setOption(project, vFile, this.myValue);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

            public void undo() {
                SetInspectionOptionFix.this.setOption(project, vFile, !SetInspectionOptionFix.this.myValue);
            }

            public void redo() {
                SetInspectionOptionFix.this.setOption(project, vFile, SetInspectionOptionFix.this.myValue);
            }
        });
    }

    private void setOption(@NotNull Project project, @NotNull VirtualFile vFile, boolean value2) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(vFile);
        if (file == null) {
            return;
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model -> {
            InspectionToolWrapper tool = model.getToolById(this.myID, (PsiElement)file);
            if (tool == null) {
                return;
            }
            InspectionProfileEntry inspection = tool.getTool();
            ReflectionUtil.setField(inspection.getClass(), (Object)inspection, Boolean.TYPE, (String)this.myProperty, (Object)value2);
        });
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }
}

