/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.SpecialFieldValue;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyOptionalCallChainsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1);
    private static final CallMatcher OPTIONAL_GET = CallMatcher.instanceCall("java.util.Optional", "get").parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable", "of").parameterCount(1);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isPresent").parameterCount(0));
    private static final CallMatcher OPTIONAL_IS_EMPTY = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isEmpty").parameterCount(0));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)holder.getFile());
        if (level.isLessThan(LanguageLevel.JDK_1_8)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new OptionalChainVisitor(level){

            @Override
            protected void handleSimplification(@NotNull PsiElement element, @NotNull OptionalChainSimplification simplification) {
                holder.registerProblem(element, simplification.getDescription(), new LocalQuickFix[]{new OptionalChainFix(simplification)});
            }
        };
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiExpression initializer) {
        PsiMethodReferenceExpression methodRef;
        PsiLambdaExpression lambda2;
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
        if (expression2 instanceof PsiLambdaExpression) {
            return (PsiLambdaExpression)expression2;
        }
        if (expression2 instanceof PsiMethodReferenceExpression && (lambda2 = LambdaRefactoringUtil.createLambda(methodRef = (PsiMethodReferenceExpression)expression2, true)) != null) {
            LambdaRefactoringUtil.specifyLambdaParameterTypes(methodRef.getFunctionalInterfaceType(), lambda2);
            return lambda2;
        }
        return null;
    }

    @Nullable
    private static PsiExpression extractFalseArg(@NotNull PsiMethodCallExpression call) {
        if (OPTIONAL_OR_ELSE.test(call)) {
            return call.getArgumentList().getExpressions()[0];
        }
        if (OPTIONAL_OR_ELSE_GET.test(call)) {
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
            if (lambda2 == null || !lambda2.getParameterList().isEmpty()) {
                return null;
            }
            return LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
        }
        return null;
    }

    private static class SimplifyOptionalChainFix
    implements OptionalChainSimplification {
        private final String myReplacement;
        private final String myMessage;
        private final String myDescription;

        private SimplifyOptionalChainFix(String replacement, String message2, String description) {
            this.myReplacement = replacement;
            this.myMessage = message2;
            this.myDescription = description;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myMessage;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.myDescription;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression replacementExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myReplacement, (PsiElement)call);
            PsiElement result = call.replace((PsiElement)replacementExpression);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        }
    }

    private static class FlipEmptyPresentFix
    implements OptionalChainSimplification {
        private final String myReplacement;

        private FlipEmptyPresentFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Override
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacement + "()"});
        }

        @Override
        @NotNull
        public String getDescription() {
            return "'" + this.myReplacement + "()' can be used instead";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiPrefixExpression negation = (PsiPrefixExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiPrefixExpression.class);
            if (negation == null || BoolUtils.getNegated((PsiExpression)negation) != call) {
                return;
            }
            ExpressionUtils.bindCallTo(call, this.myReplacement);
            new CommentTracker().replaceAndRestoreComments((PsiElement)negation, (PsiElement)call);
        }
    }

    private static class OrElseNonNullActionFix
    implements OptionalChainSimplification {
        private OrElseNonNullActionFix() {
        }

        @Override
        @NotNull
        public String getName() {
            return "Replace null check with ifPresent()";
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Remove redundant null check";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false);
            if (call == null) {
                return;
            }
            PsiExpression falseArg = SimplifyOptionalCallChainsInspection.extractFalseArg(call);
            if (!ExpressionUtils.isNullLiteral(falseArg)) {
                return;
            }
            Context context = Context.extract(call, falseArg);
            if (context == null) {
                return;
            }
            PsiExpression receiver2 = context.getOrElseCall().getMethodExpression().getQualifierExpression();
            if (receiver2 == null) {
                return;
            }
            String statementText = receiver2.getText() + ".ifPresent(" + LambdaUtil.createLambda((PsiVariable)context.getVariable(), (PsiExpression)context.getAction()) + ");";
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(statementText, (PsiElement)context.getStatement());
            PsiElement result = context.getStatement().replace((PsiElement)finalStatement);
            context.getConditionStatement().delete();
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Nullable
        private static PsiExpression extractMappingExpression(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
            if (ifStatement == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            if (ExpressionUtils.getVariableFromNullComparison(condition2, false) != optValue) {
                return null;
            }
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenStatement, PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return null;
            }
            return expressionStatement.getExpression();
        }

        private static class Context {
            @NotNull
            private final PsiExpression myAction;
            @NotNull
            private final PsiStatement myConditionStatement;
            @NotNull
            private final PsiStatement myStatement;
            @NotNull
            private final PsiVariable myVariable;
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;

            @NotNull
            public PsiExpression getAction() {
                return this.myAction;
            }

            @NotNull
            public PsiStatement getConditionStatement() {
                return this.myConditionStatement;
            }

            @NotNull
            public PsiStatement getStatement() {
                return this.myStatement;
            }

            @NotNull
            public PsiMethodCallExpression getOrElseCall() {
                return this.myOrElseCall;
            }

            private Context(@NotNull PsiExpression action, @NotNull PsiStatement conditionStatement, @NotNull PsiStatement statement, @NotNull PsiVariable variable, @NotNull PsiMethodCallExpression call) {
                this.myAction = action;
                this.myConditionStatement = conditionStatement;
                this.myStatement = statement;
                this.myVariable = variable;
                this.myOrElseCall = call;
            }

            @NotNull
            public PsiVariable getVariable() {
                return this.myVariable;
            }

            @Nullable
            static Context extract(@NotNull PsiMethodCallExpression orElseCall, @NotNull PsiExpression orElseArgument) {
                if (!ExpressionUtils.isNullLiteral(orElseArgument)) {
                    return null;
                }
                PsiLocalVariable returnVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)orElseCall.getParent(), PsiLocalVariable.class);
                if (returnVar == null) {
                    return null;
                }
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)returnVar, PsiStatement.class, (boolean)true);
                if (statement == null) {
                    return null;
                }
                PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
                if (nextStatement == null) {
                    return null;
                }
                PsiExpression lambdaExpr = OrElseNonNullActionFix.extractMappingExpression(nextStatement, (PsiVariable)returnVar);
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaExpr)) {
                    return null;
                }
                if (!ReferencesSearch.search((PsiElement)returnVar).allMatch(reference -> PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)nextStatement, (PsiElement)reference.getElement(), (boolean)false))) {
                    return null;
                }
                return new Context(lambdaExpr, nextStatement, statement, (PsiVariable)returnVar, orElseCall);
            }
        }
    }

    private static class OrElseReturnStreamFix
    implements OptionalChainSimplification {
        @NotNull
        private final String defaultExpression;
        private final boolean myIsSimple;

        private OrElseReturnStreamFix(@NotNull PsiExpression expression2, boolean simple) {
            this.defaultExpression = PsiExpressionTrimRenderer.render((PsiExpression)expression2);
            this.myIsSimple = simple;
        }

        @Override
        @NotNull
        public String getName() {
            String method = this.myIsSimple ? "orElse" : "orElseGet";
            return "Replace null check with " + method + "(" + this.defaultExpression + ")";
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Remove redundant null check";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull PsiElement element) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false);
            if (call == null) {
                return;
            }
            PsiExpression falseArg = SimplifyOptionalCallChainsInspection.extractFalseArg(call);
            if (!ExpressionUtils.isNullLiteral(falseArg)) {
                return;
            }
            Context context = Context.extract(call, falseArg);
            if (context == null) {
                return;
            }
            PsiExpression receiver2 = context.getOrElseCall().getMethodExpression().getQualifierExpression();
            if (receiver2 == null) {
                return;
            }
            String methodWithArg = context.isSimple() ? ".orElse(" + context.getDefaultExpression().getText() + ")" : ".orElseGet(()->" + context.getDefaultExpression().getText() + ")";
            String expressionText = receiver2.getText() + methodWithArg;
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("return " + expressionText + ";", (PsiElement)receiver2);
            PsiStatement current = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context.getOrElseCall(), PsiStatement.class, (boolean)false);
            if (current == null) {
                return;
            }
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)current, (PsiElement)finalStatement);
            new CommentTracker().deleteAndRestoreComments((PsiElement)context.getNextStatement());
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Nullable
        private static PsiExpression extractConditionalDefaultValue(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
            if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition2 = ifStatement.getCondition();
                if (condition2 == null) {
                    return null;
                }
                PsiExpression thenExpr = OrElseReturnStreamFix.getReturnExpression(ifStatement.getThenBranch());
                PsiExpression elseExpr = OrElseReturnStreamFix.getReturnExpression(ifStatement.getElseBranch());
                if (thenExpr == null || elseExpr == null) {
                    return null;
                }
                return OrElseReturnStreamFix.extractConditionalDefaultValue(thenExpr, elseExpr, condition2, optValue);
            }
            if (statement instanceof PsiReturnStatement) {
                PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
                PsiConditionalExpression ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)returnValue), PsiConditionalExpression.class);
                if (ternary == null) {
                    return null;
                }
                PsiExpression thenExpression2 = ternary.getThenExpression();
                PsiExpression elseExpression2 = ternary.getElseExpression();
                if (thenExpression2 == null || elseExpression2 == null) {
                    return null;
                }
                return OrElseReturnStreamFix.extractConditionalDefaultValue(thenExpression2, elseExpression2, ternary.getCondition(), optValue);
            }
            return null;
        }

        @Contract(value="null -> null")
        @Nullable
        private static PsiExpression getReturnExpression(@Nullable PsiStatement block) {
            if (block == null) {
                return null;
            }
            PsiStatement statement = ControlFlowUtils.stripBraces(block);
            PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)statement, PsiReturnStatement.class);
            if (returnStatement == null) {
                return null;
            }
            return returnStatement.getReturnValue();
        }

        @Nullable
        private static PsiExpression extractConditionalDefaultValue(@NotNull PsiExpression thenExpr, @NotNull PsiExpression elseExpr, @NotNull PsiExpression condition2, @NotNull PsiVariable optValue) {
            PsiExpression defaultExpression;
            PsiVariable nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, true);
            boolean inverted = false;
            if (nullChecked == null) {
                nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, false);
                if (nullChecked == null) {
                    return null;
                }
                inverted = true;
            }
            if (!nullChecked.equals(optValue) || !ExpressionUtils.isReferenceTo(inverted ? thenExpr : elseExpr, optValue)) {
                return null;
            }
            PsiExpression psiExpression = defaultExpression = inverted ? elseExpr : thenExpr;
            if (VariableAccessUtils.variableIsUsed(optValue, (PsiElement)defaultExpression)) {
                return null;
            }
            return defaultExpression;
        }

        private static class Context {
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;
            @NotNull
            private final PsiExpression myDefaultExpression;
            @NotNull
            private final PsiStatement myNextStatement;
            private final boolean mySimple;

            private Context(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression defaultExpression, @NotNull PsiStatement nextStatement, boolean simple) {
                this.myOrElseCall = call;
                this.myDefaultExpression = defaultExpression;
                this.myNextStatement = nextStatement;
                this.mySimple = simple;
            }

            @NotNull
            public PsiStatement getNextStatement() {
                return this.myNextStatement;
            }

            @NotNull
            public PsiMethodCallExpression getOrElseCall() {
                return this.myOrElseCall;
            }

            @NotNull
            public PsiExpression getDefaultExpression() {
                return this.myDefaultExpression;
            }

            public boolean isSimple() {
                return this.mySimple;
            }

            @Nullable
            static Context extract(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression falseArg) {
                if (!ExpressionUtils.isNullLiteral(falseArg)) {
                    return null;
                }
                PsiLocalVariable returnVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)call, PsiLocalVariable.class, (boolean)true);
                if (returnVar == null) {
                    return null;
                }
                PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
                if (nextStatement == null) {
                    return null;
                }
                PsiExpression defaultValue = OrElseReturnStreamFix.extractConditionalDefaultValue(nextStatement, (PsiVariable)returnVar);
                boolean isSimple = ExpressionUtils.isSafelyRecomputableExpression(defaultValue);
                if (defaultValue == null || !isSimple && !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)defaultValue)) {
                    return null;
                }
                PsiType type2 = defaultValue.getType();
                PsiType methodCallReturnValue = call.getMethodExpression().getType();
                if (type2 == null || methodCallReturnValue == null || !methodCallReturnValue.isAssignableFrom(type2)) {
                    return null;
                }
                return new Context(call, defaultValue, nextStatement, isSimple);
            }
        }
    }

    private static class OptionalChainFix
    implements LocalQuickFix {
        @NotNull
        private final OptionalChainSimplification mySimplification;

        OptionalChainFix(@NotNull OptionalChainSimplification simplification) {
            this.mySimplification = simplification;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.mySimplification.getName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Simplify optional call chain";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            this.mySimplification.applyFix(project, descriptor.getStartElement());
        }
    }

    static interface OptionalChainSimplification {
        @NotNull
        public String getName();

        @NotNull
        public String getDescription();

        public void applyFix(@NotNull Project var1, @NotNull PsiElement var2);
    }

    private static abstract class OptionalChainVisitor
    extends JavaElementVisitor {
        private final LanguageLevel myLevel;

        private OptionalChainVisitor(LanguageLevel level) {
            this.myLevel = level;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            if (OPTIONAL_GET.test(call)) {
                this.handleRewrapping(call, OPTIONAL_OF_OF_NULLABLE);
                return;
            }
            this.handleInvertedPresentOrEmpty(call);
            PsiExpression falseArg = null;
            boolean useOrElseGet = false;
            if (OPTIONAL_OR_ELSE.test(call)) {
                falseArg = call.getArgumentList().getExpressions()[0];
            } else if (OPTIONAL_OR_ELSE_GET.test(call)) {
                useOrElseGet = true;
                PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
                if (lambda2 == null || !lambda2.getParameterList().isEmpty()) {
                    return;
                }
                falseArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            }
            if (falseArg == null) {
                return;
            }
            this.handleMapOrElse(call, useOrElseGet, falseArg);
            if (ExpressionUtils.isNullLiteral(falseArg)) {
                this.handleRewrapping(call, OPTIONAL_OF_NULLABLE);
            }
            this.handleOrElseNullConditionalReturn(call, falseArg);
            this.handleOrElseNullConditionalAction(call, falseArg);
        }

        private void handleInvertedPresentOrEmpty(PsiMethodCallExpression call) {
            if (this.myLevel.isLessThan(LanguageLevel.JDK_11)) {
                return;
            }
            if (!BoolUtils.isNegated((PsiExpression)call)) {
                return;
            }
            PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            if (OPTIONAL_IS_EMPTY.test(call)) {
                this.handleSimplification(nameElement, new FlipEmptyPresentFix("isPresent"));
            } else if (OPTIONAL_IS_PRESENT.test(call)) {
                this.handleSimplification(nameElement, new FlipEmptyPresentFix("isEmpty"));
            }
        }

        private void handleRewrapping(PsiMethodCallExpression call, CallMatcher wrapper) {
            SpecialFieldValue fact;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
            if (!wrapper.test(parentCall)) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null || !EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), parentCall.getType())) {
                return;
            }
            if ("get".equals(call.getMethodExpression().getReferenceName()) && DfaFactType.NULLABILITY.fromDfaValue(SpecialField.OPTIONAL_VALUE.extract(fact = CommonDataflow.getExpressionFact(qualifier, DfaFactType.SPECIAL_FIELD_VALUE))) != DfaNullability.NOT_NULL) {
                return;
            }
            SimplifyOptionalChainFix fix2 = new SimplifyOptionalChainFix(qualifier.getText(), "Unwrap", "Unnecessary Optional rewrapping");
            this.handleSimplification(Objects.requireNonNull(parentCall.getMethodExpression().getReferenceNameElement()), fix2);
        }

        private void handleMapOrElse(PsiMethodCallExpression call, boolean useOrElseGet, PsiExpression falseArg) {
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (!OPTIONAL_MAP.test(qualifierCall)) {
                return;
            }
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(qualifierCall.getArgumentList().getExpressions()[0]);
            if (lambda2 == null) {
                return;
            }
            PsiExpression trueArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (trueArg == null) {
                return;
            }
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return;
            }
            PsiExpression qualifier = qualifierCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String opt = qualifier.getText();
            PsiParameter parameter2 = parameters2[0];
            String proposed = OptionalRefactoringUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
            String canonicalOrElse = useOrElseGet && !ExpressionUtils.isSafelyRecomputableExpression(falseArg) ? ".orElseGet(() -> " + falseArg.getText() + ")" : ".orElse(" + falseArg.getText() + ")";
            String canonical = opt + ".map(" + LambdaUtil.createLambda((PsiVariable)parameter2, (PsiExpression)trueArg) + ")" + canonicalOrElse;
            if (proposed.length() < canonical.length()) {
                String displayCode;
                if (proposed.equals(opt)) {
                    displayCode = "";
                } else if (opt.length() > 10) {
                    opt = "(($))";
                    String template = OptionalRefactoringUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(template, (PsiElement)call));
                    displayCode = displayCode.replaceFirst(Pattern.quote(opt), "..");
                } else {
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(proposed, (PsiElement)call));
                }
                String message2 = displayCode.isEmpty() ? "Remove redundant steps from optional chain" : "Simplify optional chain to '" + displayCode + "'";
                SimplifyOptionalChainFix fix2 = new SimplifyOptionalChainFix(proposed, message2, "Optional chain can be simplified");
                this.handleSimplification(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), fix2);
            }
        }

        private void handleOrElseNullConditionalReturn(PsiMethodCallExpression call, PsiExpression falseArg) {
            OrElseReturnStreamFix.Context context = OrElseReturnStreamFix.Context.extract(call, falseArg);
            if (context == null) {
                return;
            }
            OrElseReturnStreamFix fix2 = new OrElseReturnStreamFix(context.getDefaultExpression(), context.isSimple());
            this.handleSimplification(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), fix2);
        }

        private void handleOrElseNullConditionalAction(PsiMethodCallExpression call, PsiExpression falseArg) {
            if (OrElseNonNullActionFix.Context.extract(call, falseArg) == null) {
                return;
            }
            OrElseNonNullActionFix fix2 = new OrElseNonNullActionFix();
            this.handleSimplification(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), fix2);
        }

        protected abstract void handleSimplification(@NotNull PsiElement var1, @NotNull OptionalChainSimplification var2);
    }
}

