/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NonNlsUastUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UastCallMatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

public class StringToUpperWithoutLocale2Inspection
extends AbstractBaseUastLocalInspectionTool {
    private static final UastCallMatcher MATCHER = UastCallMatcher.anyOf((UastCallMatcher[])new UastCallMatcher[]{UastCallMatcher.builder().withMethodName("toUpperCase").withClassFqn("java.lang.String").withArgumentsCount(0).build(), UastCallMatcher.builder().withMethodName("toLowerCase").withClassFqn("java.lang.String").withArgumentsCount(0).build()});

    @Nls
    @NotNull
    public String getDisplayName() {
        return "StringToUpperWithoutLocale2Inspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                UCallExpression callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element);
                if (callExpression != null) {
                    StringToUpperWithoutLocale2Inspection.handleCallExpression(callExpression, holder);
                    return;
                }
                if (!(element instanceof PsiIdentifier)) {
                    return;
                }
                PsiElement parent = element.getParent();
                UElement parentUElement = UastContextKt.toUElement((PsiElement)parent);
                if (parentUElement instanceof UCallableReferenceExpression) {
                    StringToUpperWithoutLocale2Inspection.handleCallableReferenceExpression((UCallableReferenceExpression)parentUElement, element, holder);
                }
            }
        };
    }

    private static void handleCallExpression(@NotNull UCallExpression callExpression, @NotNull ProblemsHolder holder) {
        if (!MATCHER.testCallExpression(callExpression)) {
            return;
        }
        if (NonNlsUastUtil.isCallExpressionWithNonNlsReceiver((UCallExpression)callExpression)) {
            return;
        }
        PsiElement methodIdentifierPsi = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression);
        if (methodIdentifierPsi == null) {
            return;
        }
        String methodName = callExpression.getMethodName();
        if (methodName == null) {
            return;
        }
        holder.registerProblem(methodIdentifierPsi, StringToUpperWithoutLocale2Inspection.getErrorDescription(methodName), new LocalQuickFix[0]);
    }

    private static void handleCallableReferenceExpression(@NotNull UCallableReferenceExpression expression2, @NotNull PsiElement identifier, @NotNull ProblemsHolder holder) {
        if (!MATCHER.testCallableReferenceExpression(expression2)) {
            return;
        }
        if (NonNlsUastUtil.isCallableReferenceExpressionWithNonNlsQualifier((UCallableReferenceExpression)expression2)) {
            return;
        }
        holder.registerProblem(identifier, StringToUpperWithoutLocale2Inspection.getErrorDescription(expression2.getCallableName()), new LocalQuickFix[0]);
    }

    @NotNull
    private static String getErrorDescription(@NotNull String methodName) {
        return JvmAnalysisBundle.message("jvm.inspections.string.touppercase.tolowercase.without.locale.description", methodName);
    }
}

