/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressManagerImpl
extends SuppressManager
implements RedundantSuppressionDetector {
    private static final Logger LOG = Logger.getInstance(SuppressManager.class);

    @NotNull
    public SuppressIntentionAction[] createSuppressActions(@NotNull HighlightDisplayKey displayKey) {
        SuppressQuickFix[] batchSuppressActions = this.createBatchSuppressActions(displayKey);
        return SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions((SuppressQuickFix[])batchSuppressActions);
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        HighlightDisplayKey displayKey = HighlightDisplayKey.findById((String)toolId);
        LOG.assertTrue(displayKey != null, (Object)("Display key is null for `" + toolId + "` tool"));
        return this.createBatchSuppressActions(displayKey);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        return JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId) != null;
    }

    @Nullable
    public String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    @Nullable
    public PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        return JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId);
    }

    public boolean canHave15Suppressions(@NotNull PsiElement file) {
        return JavaSuppressionUtil.canHave15Suppressions(file);
    }

    public boolean alreadyHas14Suppressions(@NotNull PsiDocCommentOwner commentOwner) {
        return JavaSuppressionUtil.alreadyHas14Suppressions((PsiJavaDocumentedElement)commentOwner);
    }

    public String getSuppressionIds(@NotNull PsiElement element) {
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    public boolean isSuppressionFor(@NotNull PsiElement elementWithSuppression, @NotNull PsiElement place, @NotNull String toolId) {
        PsiElement suppressionScope = JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId);
        return suppressionScope != null && PsiTreeUtil.isAncestor((PsiElement)elementWithSuppression, (PsiElement)suppressionScope, (boolean)false);
    }

    public LocalQuickFix createRemoveRedundantSuppressionFix(@NotNull String toolId) {
        return new RemoveSuppressWarningAction(toolId);
    }
}

