/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AnnotatedElementInspectionBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class UnstableApiUsageInspection
extends AnnotatedElementInspectionBase {
    public final List<String> unstableApiAnnotations = new ExternalizableStringSet("org.jetbrains.annotations.ApiStatus.Experimental", "org.jetbrains.annotations.ApiStatus.Internal", "com.google.common.annotations.Beta", "io.reactivex.annotations.Beta", "io.reactivex.annotations.Experimental", "rx.annotations.Experimental", "rx.annotations.Beta", "org.apache.http.annotation.Beta", "org.gradle.api.Incubating");

    @Override
    @NotNull
    protected List<String> getAnnotations() {
        return this.unstableApiAnnotations;
    }

    @Override
    protected void createProblem(@NotNull PsiReference reference, @NotNull PsiModifierListOwner annotatedTarget, @NotNull List<PsiAnnotation> annotations2, @NotNull ProblemsHolder holder) {
        String message2 = JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.description", DeprecationInspectionBase.getPresentableName((PsiElement)annotatedTarget));
        holder.registerProblem(reference, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Override
    @NotNull
    public JPanel createOptionsPanel() {
        JPanel checkboxPanel = super.createOptionsPanel();
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl(this.unstableApiAnnotations, JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.annotations.list", new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)checkboxPanel, "North");
        panel.add((Component)annotationsListControl, "Center");
        return panel;
    }
}

