/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class WrapperTypeMayBePrimitiveInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher TO_STRING = CallMatcher.instanceCall("java.lang.Object", "toString");
    private static final CallMatcher HASH_CODE = CallMatcher.instanceCall("java.lang.Object", "hashCode");
    private static final CallMatcher VALUE_OF = WrapperTypeMayBePrimitiveInspection.getValueOfMatcher();
    private static final Map<String, String> ourReplacementMap = new HashMap<String, String>();
    private static final Set<String> ourAllowedInstanceCalls = new HashSet<String>();

    private static CallMatcher getValueOfMatcher() {
        CallMatcher[] matchers = (CallMatcher[])JvmPrimitiveTypeKind.getBoxedFqns().stream().filter(fqn -> !fqn.equals("java.lang.Character")).map(fqn -> CallMatcher.staticCall(fqn, "valueOf").parameterTypes("java.lang.String")).toArray(CallMatcher[]::new);
        return CallMatcher.anyOf(matchers);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiCodeBlock body2 = method.getBody();
                if (body2 == null) {
                    return;
                }
                WrapperTypeMayBePrimitiveDetectingVisitor visitor = new WrapperTypeMayBePrimitiveDetectingVisitor();
                body2.accept((PsiElementVisitor)visitor);
                for (PsiLocalVariable variable : visitor.getVariablesToUnbox()) {
                    holder.registerProblem((PsiElement)variable.getTypeElement(), InspectionsBundle.message((String)"inspection.wrapper.type.may.be.primitive.name", (Object[])new Object[0]), new LocalQuickFix[]{new ConvertWrapperTypeToPrimitive()});
                }
            }
        };
    }

    private static boolean isValueOfCall(PsiExpression expression2) {
        return expression2 instanceof PsiMethodCallExpression && VALUE_OF.test((PsiMethodCallExpression)expression2);
    }

    static {
        ourReplacementMap.put("java.lang.Integer", "parseInt");
        ourReplacementMap.put("java.lang.Long", "parseLong");
        ourReplacementMap.put("java.lang.Float", "parseFloat");
        ourReplacementMap.put("java.lang.Boolean", "parseBoolean");
        ourReplacementMap.put("java.lang.Double", "parseDouble");
        ourReplacementMap.put("java.lang.Short", "parseShort");
        ourReplacementMap.put("java.lang.Byte", "parseByte");
        ourAllowedInstanceCalls.add("isInfinite");
        ourAllowedInstanceCalls.add("isNaN");
        ourAllowedInstanceCalls.add("byteValue");
        ourAllowedInstanceCalls.add("shortValue");
        ourAllowedInstanceCalls.add("intValue");
        ourAllowedInstanceCalls.add("longValue");
        ourAllowedInstanceCalls.add("floatValue");
        ourAllowedInstanceCalls.add("doubleValue");
    }

    private static class ConvertWrapperTypeToPrimitive
    implements LocalQuickFix {
        private ConvertWrapperTypeToPrimitive() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return this.getFamilyName();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.wrapper.type.may.be.primitive.fix.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiType type2;
            String boxedType;
            String unboxedType;
            PsiElement element = descriptor.getStartElement();
            PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.tryCast((Object)element, PsiTypeElement.class);
            if (typeElement == null) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)typeElement.getParent(), PsiLocalVariable.class);
            if (variable == null) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ConvertWrapperTypeToPrimitive.tryReplaceStaticCall(initializer);
            }
            if ((unboxedType = PsiTypesUtil.unboxIfPossible((String)(boxedType = (type2 = variable.getType()).getCanonicalText()))).equals(boxedType)) {
                return;
            }
            PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
            if (codeBlock == null) {
                return;
            }
            codeBlock.accept((PsiElementVisitor)new UnboxingVisitor(variable));
            new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, unboxedType);
        }

        private static void tryReplaceStaticCall(PsiExpression expression2) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
            if (!VALUE_OF.test(callExpression)) {
                return;
            }
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            String replacementMethodCall = (String)ourReplacementMap.get(containingClassName);
            if (replacementMethodCall == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String argumentText = tracker.text((PsiElement)argument);
            String replacementText = containingClassName + "." + replacementMethodCall + "(" + argumentText + ")";
            tracker.replaceAndRestoreComments((PsiElement)callExpression, replacementText);
        }

        private static void replaceInstanceCall(PsiMethodCallExpression call) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return;
            }
            String qualifierTypeText = qualifierType.getCanonicalText();
            CommentTracker tracker = new CommentTracker();
            String qualifierText = tracker.text((PsiElement)qualifier);
            String replacement = ConvertWrapperTypeToPrimitive.findStaticReplacement(call, qualifierText, qualifierTypeText);
            if (replacement == null) {
                return;
            }
            tracker.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        private static String findStaticReplacement(PsiMethodCallExpression call, String qualifierText, String qualifierTypeText) {
            String type2;
            String callName = call.getMethodExpression().getReferenceName();
            String methodNameText = HASH_CODE.test(call) ? "hashCode" : (TO_STRING.test(call) ? "toString" : ("isInfinite".equals(callName) ? "isInfinite" : ("isNaN".equals(callName) ? "isNaN" : null)));
            if (methodNameText != null) {
                return qualifierTypeText + "." + methodNameText + "(" + qualifierText + ")";
            }
            if ("intValue".equals(callName)) {
                type2 = "int";
            } else if ("byteValue".equals(callName)) {
                type2 = "byte";
            } else if ("floatValue".equals(callName)) {
                type2 = "float";
            } else if ("doubleValue".equals(callName)) {
                type2 = "double";
            } else if ("shortValue".equals(callName)) {
                type2 = "short";
            } else {
                return null;
            }
            return "(" + type2 + ")" + qualifierText;
        }

        private static class UnboxingVisitor
        extends JavaRecursiveElementVisitor {
            private final PsiLocalVariable myVariable;

            UnboxingVisitor(PsiLocalVariable variable) {
                this.myVariable = variable;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (!ExpressionUtils.isReferenceTo((PsiExpression)expression2, (PsiVariable)this.myVariable)) {
                    return;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2).getParent();
                PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression2);
                if (call != null) {
                    ConvertWrapperTypeToPrimitive.replaceInstanceCall(call);
                } else if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                    if (!ExpressionUtils.isReferenceTo(assignment.getLExpression(), (PsiVariable)this.myVariable)) {
                        return;
                    }
                    ConvertWrapperTypeToPrimitive.tryReplaceStaticCall(assignment.getRExpression());
                }
            }
        }
    }

    private static class WrapperTypeMayBePrimitiveDetectingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private static final int IN_LOOP_ASSIGNMENT_OPERATION_MULTIPLIER = 10;
        private final Map<String, List<BoxingInfo>> myBoxingMap = new HashMap<String, List<BoxingInfo>>();

        private WrapperTypeMayBePrimitiveDetectingVisitor() {
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)variable.getType())) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            BoxingInfo boxingInfo = new BoxingInfo(variable);
            if (initializer != null && !boxingInfo.checkExpression(initializer)) {
                return;
            }
            String name = variable.getName();
            if (name == null) {
                return;
            }
            ArrayList<BoxingInfo> infos = new ArrayList<BoxingInfo>();
            infos.add(boxingInfo);
            this.myBoxingMap.put(name, infos);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            String name = expression2.getReferenceName();
            if (name == null) {
                return;
            }
            List<BoxingInfo> infos = this.myBoxingMap.get(name);
            if (infos == null) {
                return;
            }
            Iterator<BoxingInfo> iterator = infos.iterator();
            while (iterator.hasNext()) {
                BoxingInfo boxingInfo = iterator.next();
                if (!ExpressionUtils.isReferenceTo((PsiExpression)expression2, (PsiVariable)boxingInfo.myVariable)) continue;
                boxingInfo.myHasReferences = true;
                if (WrapperTypeMayBePrimitiveDetectingVisitor.referenceUseAllowUnboxing(expression2, boxingInfo)) break;
                iterator.remove();
                break;
            }
            if (infos.isEmpty()) {
                this.myBoxingMap.remove(name);
            }
        }

        public List<PsiLocalVariable> getVariablesToUnbox() {
            ArrayList<PsiLocalVariable> variables = new ArrayList<PsiLocalVariable>();
            for (List<BoxingInfo> infos : this.myBoxingMap.values()) {
                for (BoxingInfo boxingInfo : infos) {
                    if (!boxingInfo.myHasReferences || !boxingInfo.primitiveReplacementReducesUnnecessaryOperationCount()) continue;
                    variables.add(boxingInfo.myVariable);
                }
            }
            return variables;
        }

        private static boolean isAllowedInstanceCall(@NotNull PsiMethodCallExpression call) {
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            if (method.hasModifier(JvmModifier.STATIC)) {
                return false;
            }
            return ourAllowedInstanceCalls.contains(call.getMethodExpression().getReferenceName());
        }

        private static boolean referenceUseAllowUnboxing(@NotNull PsiReferenceExpression expression2, @NotNull BoxingInfo boxingInfo) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2).getParent();
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression2);
            if (call != null) {
                return TO_STRING.test(call) || HASH_CODE.test(call) || WrapperTypeMayBePrimitiveDetectingVisitor.isAllowedInstanceCall(call);
            }
            if (parent instanceof PsiExpressionList) {
                int parameterIndex;
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiCallExpression)) {
                    return true;
                }
                Object[] arguments = ((PsiExpressionList)parent).getExpressions();
                int argumentsIndex = ArrayUtil.indexOf((Object[])arguments, (Object)expression2);
                if (argumentsIndex == -1) {
                    return true;
                }
                PsiCallExpression callExpression = (PsiCallExpression)grandParent;
                PsiMethod method = callExpression.resolveMethod();
                if (method == null) {
                    return true;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                int n = parameterIndex = parameters2.length < argumentsIndex + 1 ? parameters2.length - 1 : argumentsIndex;
                if (parameterIndex < 0) {
                    return false;
                }
                PsiParameter parameter2 = parameters2[parameterIndex];
                PsiType type2 = parameter2.getType();
                if (type2 instanceof PsiPrimitiveType) {
                    boxingInfo.myBoxedUnnecessaryOperationCount++;
                } else {
                    boxingInfo.myUnboxedUnnecessaryOperationCount++;
                }
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
                if (rExpression == null) {
                    return true;
                }
                if (!boxingInfo.checkExpression(rExpression)) {
                    return false;
                }
            } else {
                PsiType returnType;
                PsiMethod method;
                if (parent instanceof PsiSynchronizedStatement) {
                    return false;
                }
                if (parent instanceof PsiBinaryExpression) {
                    return WrapperTypeMayBePrimitiveDetectingVisitor.binaryExpressionUseAllowUnboxing((PsiBinaryExpression)parent, boxingInfo);
                }
                if (parent instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiLambdaExpression.class})) != null && (returnType = method.getReturnType()) != null) {
                    if (returnType instanceof PsiPrimitiveType) {
                        boxingInfo.myBoxedUnnecessaryOperationCount++;
                    } else {
                        boxingInfo.myUnboxedUnnecessaryOperationCount++;
                    }
                }
            }
            return true;
        }

        private static boolean binaryExpressionUseAllowUnboxing(@NotNull PsiBinaryExpression binaryExpression, @NotNull BoxingInfo boxingInfo) {
            IElementType operationTokenType = binaryExpression.getOperationTokenType();
            PsiExpression other = ExpressionUtils.getOtherOperand(binaryExpression, (PsiVariable)boxingInfo.myVariable);
            if (other == null) {
                return false;
            }
            PsiType type2 = other.getType();
            if (operationTokenType == JavaTokenType.EQEQ || operationTokenType == JavaTokenType.NE) {
                if (!(type2 instanceof PsiPrimitiveType) || PsiType.NULL.equals((Object)type2)) {
                    return false;
                }
                boxingInfo.myBoxedUnnecessaryOperationCount++;
            }
            int boxedUnnecessaryOpImpact = 0;
            int unboxedUnnecessaryOpImpact = 0;
            if (type2 instanceof PsiPrimitiveType) {
                if (PsiType.NULL.equals((Object)type2)) {
                    return false;
                }
                if (TypeConversionUtil.convertEQtoOperation((IElementType)binaryExpression.getOperationTokenType()) != null) {
                    boxedUnnecessaryOpImpact += 2;
                }
            } else {
                if (NullabilityUtil.getExpressionNullability(other) != Nullability.NOT_NULL) {
                    return false;
                }
                boxedUnnecessaryOpImpact += 3;
                unboxedUnnecessaryOpImpact += 3;
            }
            PsiLoopStatement binopLoop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PsiLoopStatement.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            PsiLoopStatement variableLoop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)boxingInfo.myVariable, PsiLoopStatement.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (binopLoop != null && binopLoop == variableLoop) {
                boxedUnnecessaryOpImpact *= 10;
                unboxedUnnecessaryOpImpact *= 10;
            }
            BoxingInfo boxingInfo2 = boxingInfo;
            boxingInfo2.myBoxedUnnecessaryOperationCount = boxingInfo2.myBoxedUnnecessaryOperationCount + boxedUnnecessaryOpImpact;
            boxingInfo2 = boxingInfo;
            boxingInfo2.myUnboxedUnnecessaryOperationCount = boxingInfo2.myUnboxedUnnecessaryOperationCount + unboxedUnnecessaryOpImpact;
            return true;
        }
    }

    private static class BoxingInfo {
        @NotNull
        private final PsiLocalVariable myVariable;
        boolean myHasReferences = false;
        private int myBoxedUnnecessaryOperationCount = 0;
        private int myUnboxedUnnecessaryOperationCount = 0;

        private BoxingInfo(@NotNull PsiLocalVariable variable) {
            this.myVariable = variable;
        }

        boolean checkExpression(@NotNull PsiExpression expression2) {
            if (expression2.getType() instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)expression2.getType())) {
                ++this.myBoxedUnnecessaryOperationCount;
            } else if (!WrapperTypeMayBePrimitiveInspection.isValueOfCall(expression2)) {
                if (NullabilityUtil.getExpressionNullability(expression2) != Nullability.NOT_NULL) {
                    return false;
                }
                ++this.myUnboxedUnnecessaryOperationCount;
            }
            return true;
        }

        boolean primitiveReplacementReducesUnnecessaryOperationCount() {
            return this.myUnboxedUnnecessaryOperationCount < this.myBoxedUnnecessaryOperationCount;
        }
    }
}

