/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationBasedBlockingMethodChecker
implements BlockingMethodChecker {
    private final List<String> myBlockingAnnotations;

    public AnnotationBasedBlockingMethodChecker(List<String> blockingAnnotations) {
        this.myBlockingAnnotations = blockingAnnotations;
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        if (this.myBlockingAnnotations.isEmpty()) {
            return false;
        }
        PsiClass annotationClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.jetbrains.annotations.Blocking", file.getResolveScope());
        return annotationClass != null;
    }

    public boolean isMethodBlocking(@NotNull PsiMethod method) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)method, this.myBlockingAnnotations, (boolean)false) != null;
    }
}

