/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class AnnotationBasedNonBlockingContextChecker
implements NonBlockingContextChecker {
    private final List<String> myNonBlockingAnnotations;

    public AnnotationBasedNonBlockingContextChecker(List<String> nonBlockingAnnotations) {
        this.myNonBlockingAnnotations = nonBlockingAnnotations;
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        if (this.myNonBlockingAnnotations.isEmpty()) {
            return false;
        }
        PsiClass annotationClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.jetbrains.annotations.NonBlocking", file.getResolveScope());
        return annotationClass != null;
    }

    public boolean isContextNonBlockingFor(@NotNull PsiElement element) {
        UCallExpression callExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
        if (callExpression == null) {
            return false;
        }
        UMethod callingMethod = (UMethod)UastUtils.getParentOfType((UElement)callExpression, UMethod.class);
        if (callingMethod == null) {
            return false;
        }
        PsiMethod psiCallingMethod = callingMethod.getJavaPsi();
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)psiCallingMethod, this.myNonBlockingAnnotations, (boolean)false) != null;
    }
}

