/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.blockingCallsDetection;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThrowsTypeBlockingMethodChecker
implements BlockingMethodChecker {
    private static final Set<String> BLOCKING_EXCEPTION_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.InterruptedException", "java.io.IOException"});

    public boolean isApplicable(@NotNull PsiFile file) {
        return true;
    }

    public boolean isMethodBlocking(@NotNull PsiMethod method) {
        return Arrays.stream(method.getThrowsList().getReferenceElements()).anyMatch(thrownException -> BLOCKING_EXCEPTION_TYPES.contains(thrownException.getQualifiedName()));
    }
}

