/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class Component {
    static final Component[] EMPTY_ARRAY = new Component[0];
    @NotNull
    Value value;
    @NotNull
    final EKey[] ids;

    Component(@NotNull Value value2, @NotNull Set<EKey> ids) {
        this(value2, ids.toArray(new EKey[0]));
    }

    Component(@NotNull Value value2, @NotNull EKey[] ids) {
        this.value = value2;
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component that = (Component)o;
        return this.value == that.value && Arrays.equals(this.ids, that.ids);
    }

    public int hashCode() {
        return 31 * this.value.hashCode() + Arrays.hashCode(this.ids);
    }

    public boolean remove(@NotNull EKey id) {
        boolean removed = false;
        for (int i = 0; i < this.ids.length; ++i) {
            if (!id.equals(this.ids[i])) continue;
            this.ids[i] = null;
            removed = true;
        }
        return removed;
    }

    public boolean isEmpty() {
        for (EKey id : this.ids) {
            if (id == null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component copy() {
        return new Component(this.value, (EKey[])this.ids.clone());
    }
}

