/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class HMember
implements MemberDescriptor {
    private static final int CLASS_HASH_SIZE = 10;
    private static final int SIGNATURE_HASH_SIZE = 4;
    static final int HASH_SIZE = 14;
    final long myClassHi;
    final short myClassLo;
    final int myMethod;

    HMember(Member method, MessageDigest md) {
        if (md == null) {
            md = BytecodeAnalysisConverter.getMessageDigest();
        }
        byte[] classDigest = md.digest(method.internalClassName.getBytes(CharsetToolkit.UTF8_CHARSET));
        ByteBuffer classBuffer = ByteBuffer.wrap(classDigest);
        this.myClassHi = classBuffer.getLong();
        this.myClassLo = classBuffer.getShort();
        md.update(method.methodName.getBytes(CharsetToolkit.UTF8_CHARSET));
        md.update(method.methodDesc.getBytes(CharsetToolkit.UTF8_CHARSET));
        byte[] sigDigest = md.digest();
        this.myMethod = ByteBuffer.wrap(sigDigest).getInt();
    }

    public HMember(@NotNull byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.myClassHi = buffer.getLong();
        this.myClassLo = buffer.getShort();
        this.myMethod = buffer.getInt();
    }

    @NotNull
    byte[] asBytes() {
        ByteBuffer bytes = ByteBuffer.allocate(14);
        bytes.putLong(this.myClassHi).putShort(this.myClassLo).putInt(this.myMethod);
        return bytes.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMember that = (HMember)o;
        return that.myClassHi == this.myClassHi && that.myClassLo == this.myClassLo && that.myMethod == this.myMethod;
    }

    public int hashCode() {
        int i;
        int result = 1;
        for (i = 7; i >= 0; --i) {
            result = result * 31 + (byte)(this.myClassHi >>> i * 8 & 0xFFL);
        }
        for (i = 1; i >= 0; --i) {
            result = result * 31 + (byte)(this.myClassLo >>> i * 8 & 0xFF);
        }
        for (i = 3; i >= 0; --i) {
            result = result * 31 + (byte)(this.myMethod >>> i * 8 & 0xFF);
        }
        return result;
    }

    @Override
    @NotNull
    public HMember hashed(MessageDigest md) {
        return this;
    }

    public String toString() {
        return HMember.bytesToString(this.asBytes());
    }

    static String bytesToString(byte[] key2) {
        return IntStreamEx.of((byte[])key2).mapToObj(b -> String.format("%02x", b & 0xFF)).joining((CharSequence)".");
    }
}

