/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;

public final class Member
implements MemberDescriptor {
    final String internalClassName;
    final String methodName;
    final String methodDesc;

    public Member(@NotNull String internalClassName, @NotNull String methodName, @NotNull String methodDesc) {
        this.internalClassName = internalClassName;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public Member(MethodInsnNode mNode) {
        this.internalClassName = mNode.owner;
        this.methodName = mNode.name;
        this.methodDesc = mNode.desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member method = (Member)o;
        return this.internalClassName.equals(method.internalClassName) && this.methodDesc.equals(method.methodDesc) && this.methodName.equals(method.methodName);
    }

    public int hashCode() {
        int result = this.internalClassName.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.methodDesc.hashCode();
        return result;
    }

    @Override
    @NotNull
    public HMember hashed(@Nullable MessageDigest md) {
        return new HMember(this, md);
    }

    public String toString() {
        return this.internalClassName + ' ' + this.methodName + ' ' + this.methodDesc;
    }
}

