/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Calls;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.Constraint;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.LabeledNull;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.AnalyzerExt;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LiteAnalyzerExt;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class NullableMethodAnalysis {
    private static final BasicValue lNull = new LabeledNull(0);

    NullableMethodAnalysis() {
    }

    static Result analyze(MethodNode methodNode, boolean[] origins, boolean jsr) throws AnalyzerException {
        InsnList insns = methodNode.instructions;
        Constraint[] data = new Constraint[insns.size()];
        int[] originsMapping = NullableMethodAnalysis.mapOrigins(origins);
        NullableMethodInterpreter interpreter = new NullableMethodInterpreter(insns, origins, originsMapping);
        Frame<V>[] frames = jsr ? new AnalyzerExt(interpreter, data, Constraint.EMPTY).analyze("this", methodNode) : new LiteAnalyzerExt(interpreter, data, Constraint.EMPTY).analyze("this", methodNode);
        BasicValue result = BasicValue.REFERENCE_VALUE;
        for (int i = 0; i < frames.length; ++i) {
            Frame frame = frames[i];
            if (frame == null || insns.get(i).getOpcode() != 176) continue;
            BasicValue stackTop = (BasicValue)frame.pop();
            result = NullableMethodAnalysis.combine(result, stackTop, data[i]);
        }
        if (result instanceof LabeledNull) {
            return Value.Null;
        }
        if (result instanceof Calls) {
            Calls calls = (Calls)result;
            int mergedMappedLabels = calls.mergedLabels;
            if (mergedMappedLabels != 0) {
                HashSet<Component> sum = new HashSet<Component>();
                EKey[] createdKeys = interpreter.keys;
                for (int origin = 0; origin < originsMapping.length; ++origin) {
                    int mappedOrigin = originsMapping[origin];
                    EKey createdKey = createdKeys[origin];
                    if (createdKey == null || (mergedMappedLabels & 1 << mappedOrigin) == 0) continue;
                    sum.add(new Component(Value.Null, Collections.singleton(createdKey)));
                }
                if (!sum.isEmpty()) {
                    return new Pending(sum);
                }
            }
        }
        return Value.Bot;
    }

    @NotNull
    private static int[] mapOrigins(boolean[] origins) {
        int[] originsMapping = new int[origins.length];
        int mapped = 0;
        for (int i = 0; i < origins.length; ++i) {
            originsMapping[i] = origins[i] ? mapped++ : -1;
        }
        return originsMapping;
    }

    static BasicValue combine(BasicValue v1, BasicValue v2, Constraint constraint) {
        if (v1 instanceof LabeledNull) {
            return lNull;
        }
        if (v2 instanceof LabeledNull) {
            int v2Origins = ((LabeledNull)v2).origins;
            int constraintOrigins = constraint.nulls;
            int intersect = v2Origins & constraintOrigins;
            return intersect == v2Origins ? v1 : lNull;
        }
        if (v1 instanceof Calls) {
            if (v2 instanceof Calls) {
                Calls calls1 = (Calls)v1;
                Calls calls2 = (Calls)v2;
                int labels2 = calls2.mergedLabels;
                int aliveLabels2 = labels2 - (labels2 & constraint.calls);
                return new Calls(calls1.mergedLabels | aliveLabels2);
            }
            return v1;
        }
        if (v2 instanceof Calls) {
            Calls calls2 = (Calls)v2;
            int labels2 = calls2.mergedLabels;
            int aliveLabels2 = labels2 - (labels2 & constraint.calls);
            return new Calls(aliveLabels2);
        }
        return BasicValue.REFERENCE_VALUE;
    }
}

