/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NonFinalFieldInImmutableInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Non-final field in @Immutable class";
    }

    @NotNull
    public String getShortName() {
        return "NonFinalFieldInImmutable";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitField(PsiField field) {
                super.visitField(field);
                if (field.hasModifierProperty("final")) {
                    return;
                }
                PsiClass containingClass = field.getContainingClass();
                if (containingClass != null) {
                    if (!JCiPUtil.isImmutable(containingClass)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)field.getNameIdentifier(), "Non-final field <code>#ref</code> in @Immutable class  #loc", new LocalQuickFix[0]);
                }
            }
        };
    }
}

